local assets =
{
	Asset("ANIM", "anim/pancakes.zip"),
    Asset("ATLAS", "images/inventoryimages/pancakes.xml")
}

local prefabs =
{
	"spoiled_food",
}

local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    
	MakeInventoryPhysics(inst)
    
	inst:AddTag("pancakes")
	
    inst.AnimState:SetBank("pancakes")
    inst.AnimState:SetBuild("pancakes")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = (100)
    inst.components.edible.hungervalue = (125)
	inst.components.edible.foodtype = "MEAT"
	
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM
	
    inst:AddComponent("inspectable")
	
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/pancakes.xml"
    
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
   
    return inst
end

return Prefab( "common/inventory/pancakes", fn, assets, prefabs) 