local assets =
{
	Asset("ANIM", "anim/chimichanga.zip"),
    Asset("ATLAS", "images/inventoryimages/chimichanga.xml")
}

local prefabs =
{
	"spoiled_food",
}

local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    
	MakeInventoryPhysics(inst)
    
	inst:AddTag("chimichanga")
	
    inst.AnimState:SetBank("chimichanga")
    inst.AnimState:SetBuild("chimichanga")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = (50)
    inst.components.edible.hungervalue = (80)
	inst.components.edible.foodtype = "MEAT"
	
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM
	
    inst:AddComponent("inspectable")
	
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/chimichanga.xml"
    
	
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_SLOW)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = (TUNING.GOLD_VALUES.MEAT * 1.5)
   
    return inst
end

return Prefab( "common/inventory/chimichanga", fn, assets, prefabs) 