PrefabFiles = {
	"deadpool",
	"katana",
	"pda",
	"chimichanga",
	"pancakes",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/deadpool.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/deadpool.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/deadpool.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/deadpool.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/deadpool_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/deadpool_silho.xml" ),

    Asset( "IMAGE", "bigportraits/deadpool.tex" ),
    Asset( "ATLAS", "bigportraits/deadpool.xml" ),
	
	Asset( "IMAGE", "images/map_icons/deadpool.tex" ),
	Asset( "ATLAS", "images/map_icons/deadpool.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_deadpool.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_deadpool.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_deadpool.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_deadpool.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

GLOBAL.STRINGS.NAMES.KATANA = "Katana"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.KATANA = "Sharp As Hound Teeth!"

GLOBAL.STRINGS.NAMES.PDA = "Teleport Device"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PDA = "Im Here, Then There!"

GLOBAL.STRINGS.NAMES.CHIMICHANGA = "Chimichanga"
GLOBAL.STRINGS.RECIPE_DESC.CHIMICHANGA = "Deadpool's Favourites"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.CHIMICHANGA = "Chimichangas !"

GLOBAL.STRINGS.NAMES.PANCAKES = "Pancakes"
GLOBAL.STRINGS.RECIPE_DESC.PANCAKES = "Smells Like Victory !"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.PANCAKES = "I Love The Smell Of 372,844 Pancakes In The Morning"


local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local Ingredient = GLOBAL.Ingredient
local TECH = GLOBAL.TECH

local chimichanga_recipe = Recipe("chimichanga", {Ingredient("corn", 2), Ingredient("cookedmeat", 2), Ingredient("petals", 3)}, RECIPETABS.FARM, TECH.NONE)

local pancakes_recipe = Recipe("pancakes", {Ingredient("corn", 3), Ingredient("bird_egg", 2), Ingredient("butter", 1), Ingredient("honey", 3)}, RECIPETABS.FARM, TECH.NONE)

chimichanga_recipe.atlas = "images/inventoryimages/chimichanga.xml"
pancakes_recipe.atlas = "images/inventoryimages/pancakes.xml"

chimichanga_recipe.sortkey = 9120
chimichanga_recipe.sortkey = 9121

-- The character select screen lines
STRINGS.CHARACTER_TITLES.deadpool = "The Merc Without A Mouth"
STRINGS.CHARACTER_NAMES.deadpool = "Deadpool"
STRINGS.CHARACTER_DESCRIPTIONS.deadpool = "*Health regeneration\n*Nearby Monsters Dont Drain Sanity\n*Can Teleport"
STRINGS.CHARACTER_QUOTES.deadpool = "\"Did somebody say Chimmies?\""

-- Custom speech strings
STRINGS.CHARACTERS.DEADPOOL = require "speech_deadpool"

-- The character's name as appears in-game 
STRINGS.NAMES.DEADPOOL = "Deadpool"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DEADPOOL = 
{
	GENERIC = "It's Deadpool!",
	ATTACKER = "That Deadpool looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Deadpool, friend of ghosts.",
	GHOST = "Deadpool could use a heart.",
}

-- Let the game know character is male, female, or robot
table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "deadpool")


AddMinimapAtlas("images/map_icons/deadpool.xml")
AddModCharacter("deadpool")
AddPrefabPostInit("katana")
