local assets =
{
    Asset("ANIM", "anim/reaper.zip"),
}

local prefabs =
{
    "book_fx",
}

function reaper(inst, reader)
    reader.components.sanity:DoDelta(-50)
	reader.components.health:DoDelta(-25)

    local pos = Vector3(inst.Transform:GetWorldPosition())
    local range = TUNING.REAPER_RANGE
    local ents = TheSim:FindEntities(pos.x,pos.y,pos.z,range)
        for k,v in pairs(ents) do
            if v.components.pickable and v.prefab ~= "flower" and v.prefab ~= "flower_evil"  then
                v.components.pickable:Pick(GetPlayer())
            end
			
            if v.components.crop then   --收获作物
                v.components.crop:Harvest(GetPlayer())
            end
			
			if TUNING.REAPER_DRIED then  --收获肉干
                if v.components.dryer then
                    v.components.dryer:Harvest(GetPlayer())
                end
		    end  
			
		    if TUNING.REAPER_BAMBOO then  --收获竹子
                if v.components.hackable then
                   v.components.hackable:Hack(GetPlayer(),6)			   
		        end
			end		
		    if TUNING.REAPER_HONEY then  --收获蜂蜜
                if v.components.harvestable then
                   v.components.harvestable:Harvest(GetPlayer())
                end
		    end	
	    end

	return true
end


    local function fn(Sim)
        local inst = CreateEntity()

        local inst = CreateEntity()
    	local trans = inst.entity:AddTransform()
    	local anim = inst.entity:AddAnimState()
        local sound = inst.entity:AddSoundEmitter()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("reaper")
        inst.AnimState:SetBuild("reaper")
        inst.AnimState:PlayAnimation("idle")
		
if SaveGameIndex:IsModeShipwrecked() then
	MakeInventoryFloatable(inst, "idle_water", "idle")
end

        inst:AddComponent("inspectable")
        inst:AddComponent("book")
        inst.components.book.onread = reaper

        inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/reaper.xml"
        inst:AddComponent("finiteuses")
        inst.components.finiteuses:SetMaxUses(3)
        inst.components.finiteuses:SetUses(3)
        inst.components.finiteuses:SetOnFinished(inst.Remove)
		
        MakeSmallPropagator(inst)

        return inst
    end

return Prefab("common/inventory/reaper", fn, assets, prefabs)

