require "prefabutil"

local assets =
{
    Asset("ANIM", "anim/gravesigns.zip"),
	Asset("MINIMAP_IMAGE", "gravesigns"),
}

local prefabs =
{
    "marble",
	"cutstone",
	"rock_break_fx",
}

SetSharedLootTable( 'gravesign1', 'gravesign2', 'gravesign3', 'gravesign4', 'gravesign5',
{
    {'cutstone',  1.0},
    {'cutstone',  1.0},
})

SetSharedLootTable( 'gravesignmarble1', 'gravesignmarble2', 'gravesignmarble3', 'gravesignmarble4', 'gravesignmarble5',
{
    {'marble',  1.0},
    {'marble',  1.0},
})

local function onhammered(inst, worker)
    if inst.components.burnable ~= nil and inst.components.burnable:IsBurning() then
        inst.components.burnable:Extinguish()
    end
    inst.components.lootdropper:DropLoot()
    local fx = SpawnPrefab("rock_break_fx")
    fx.Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst:Remove()
end

local function onsave(inst, data)
    if inst:HasTag("burnt") or (inst.components.burnable ~= nil and inst.components.burnable:IsBurning()) then
        data.burnt = true
    end
end

local function onload(inst, data)
    if data ~= nil and data.burnt then
        inst.components.burnable.onburnt(inst)
    end
end

local function onbuilt(inst)
    inst.SoundEmitter:PlaySound("dontstarve/common/sign_craft")
end

local function basegraves_fn(bank, build, anim, icon, tag)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddMiniMapEntity()
    inst.entity:AddNetwork()

    MakeObstaclePhysics(inst, .1)

    inst.MiniMapEntity:SetIcon("gravesigns.png")

    inst.AnimState:SetBank(bank)
    inst.AnimState:SetBuild(build)
    if type(anim) == "table" then
        for i, v in ipairs(anim) do
            if i == 1 then
                inst.AnimState:PlayAnimation(v)
            else
                inst.AnimState:PushAnimation(v, false)
            end
        end
    else
        inst.AnimState:PlayAnimation(anim)
    end
	
    MakeSnowCoveredPristine(inst)

    inst:AddTag("structure")

    --Sneak these into pristine state for optimization
    inst:AddTag("_writeable")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    --Remove these tags so that they can be added properly when replicating components below
    inst:RemoveTag("_writeable")

    inst:AddComponent("inspectable")
    inst:AddComponent("writeable")
    inst:AddComponent("lootdropper")

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
    inst.components.workable:SetOnFinishCallback(onhammered)
    MakeSnowCovered(inst)

    inst.OnSave = onsave
    inst.OnLoad = onload

    MakeHauntableWork(inst)
    inst:ListenForEvent("onbuilt", onbuilt)

    return inst
end

--STONE GRAVES

local function gravesign1_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "stone_1_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesign2_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "stone_2_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesign3_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "stone_3_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesign4_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "stone_4_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesign5_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "stone_5_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

--MARBLE GRAVES

local function gravesignmarble1_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "marble_1_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesignmarble2_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "marble_2_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesignmarble3_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "marble_3_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesignmarble4_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "marble_4_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

local function gravesignmarble5_fn()
    local inst = basegraves_fn("gravesign", "gravesigns", "marble_5_idle", "gravesigns.png")

    if not TheWorld.ismastersim then
        return inst
    end

    return inst
end

return
--PREFABS
	Prefab("gravesign1", gravesign1_fn, assets, prefabs),
	Prefab("gravesign2", gravesign2_fn, assets, prefabs),
   	Prefab("gravesign3", gravesign3_fn, assets, prefabs),
    Prefab("gravesign4", gravesign4_fn, assets, prefabs),
    Prefab("gravesign5", gravesign5_fn, assets, prefabs),
    Prefab("gravesignmarble1", gravesignmarble1_fn, assets, prefabs),
	Prefab("gravesignmarble2", gravesignmarble2_fn, assets, prefabs),
    Prefab("gravesignmarble3", gravesignmarble3_fn, assets, prefabs),
    Prefab("gravesignmarble4", gravesignmarble4_fn, assets, prefabs),
    Prefab("gravesignmarble5", gravesignmarble5_fn, assets, prefabs),
--PLACERS	
	MakePlacer("gravesign1_placer", "gravesign", "gravesigns", "stone_1_idle"),
	MakePlacer("gravesign2_placer", "gravesign", "gravesigns", "stone_2_idle"),
	MakePlacer("gravesign3_placer", "gravesign", "gravesigns", "stone_3_idle"),
	MakePlacer("gravesign4_placer", "gravesign", "gravesigns", "stone_4_idle"),
	MakePlacer("gravesign5_placer", "gravesign", "gravesigns", "stone_5_idle"),
	MakePlacer("gravesignmarble1_placer", "gravesign", "gravesigns", "marble_1_idle"),
	MakePlacer("gravesignmarble2_placer", "gravesign", "gravesigns", "marble_2_idle"),
	MakePlacer("gravesignmarble3_placer", "gravesign", "gravesigns", "marble_3_idle"),
	MakePlacer("gravesignmarble4_placer", "gravesign", "gravesigns", "marble_4_idle"),
	MakePlacer("gravesignmarble5_placer", "gravesign", "gravesigns", "marble_5_idle")