local assets=
{
	Asset("ANIM", "anim/icesword.zip"),
	Asset("ANIM", "anim/swap_icesword.zip"),
    Asset("ATLAS", "images/inventoryimages/icesword.xml"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_icesword", "swap_icesword_1")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

--冰冻技能
local function SpawnIceFx(inst, target)
    if not inst or not target then return end	
	--if not inst.qingliu then  --判定没有cd 
    local owner = inst.components.inventoryitem:GetGrandOwner()
	if not inst.components.timer:TimerExists("iceswaord_cd")then --判定没有cd 
    local numFX = math.random(15,20)
    local pos = inst:GetPosition()
    local targetPos = target:GetPosition()
    local vec = targetPos - pos
    vec = vec:Normalize()
    local dist = pos:Dist(targetPos)
    local angle = inst:GetAngleToPoint(targetPos:Get())

    for i = 1, numFX do
        inst:DoTaskInTime(math.random() * 0.25, function(inst)
            local prefab = "icespike_fx_"..math.random(1,4)
            local fx = SpawnPrefab(prefab)
            if fx then
                local x = GetRandomWithVariance(0, 5)
                local z = GetRandomWithVariance(0, 5)
                local offset = (vec * math.random(dist * 0.25, dist)) + Vector3(x,0,z)
                fx.Transform:SetPosition((offset+pos):Get())
            end
        end)
    end
			local x3, y3, z3 = target.Transform:GetWorldPosition()
			local ents = TheSim:FindEntities(x3, y3, z3, 7, nil, { "INLIMBO" })--冰冻范围
			for i, v in ipairs(ents) do 
					if v ~= inst.WINDSTAFF_CASTER 
					        and v:IsValid() 
							and not v:HasTag("player")
							and not v:HasTag("wall")
							and not v:HasTag("companion")
							and (
								    v:HasTag("monster")	--怪物
								 or v:HasTag("epic")	--boss
								 or v.components.combat and v.components.combat.target and v.components.combat.target:HasTag("player") --要伤害玩家
								 or TheNet:GetPVPEnabled() and v:HasTag("player") --敌对的队友
								)
							then
						if v.components.health ~= nil and
						not v.components.health:IsDead() and
						v.components.combat ~= nil and
						v.components.combat:CanBeAttacked() then
						v.components.combat:GetAttacked(inst, 30, nil, "icesword")--伤害
							if v.components.freezable ~= nil and not v.components.health:IsDead()then 
								v.components.freezable:AddColdness(4)--增加的冰冻值
								v.components.freezable:SpawnShatterFX()	
							end
						end
					end
	end
	--inst.qingliu  =true
	--inst:DoTaskInTime(10, function() inst.qingliu = false end) --10秒CD（注释内容为一组）
	
	inst.components.timer:StartTimer("iceswaord_cd", 20)  --进入冷却
	else --如果有CD 那么
       local timeleft = inst.components.timer:GetTimeLeft("iceswaord_cd")
       timeleft = math.ceil(timeleft * 10) / 10	 --获取冷却时间
        if owner.components.talker then
         owner.components.talker:Say("武器冷却还需要 "..timeleft.." 秒")
         end
	end
end

local function OnGetItemFromPlayer(inst, giver, item)
	if item.prefab == "bluegem" then
		inst.components.finiteuses:Use(-200)
elseif item.prefab == "ice" then
		inst.components.finiteuses:Use(-35)
elseif item.prefab == "goldnugget" then
		inst.components.finiteuses:Use(-25)		
	end	
	if inst.components.finiteuses:GetPercent() > 1 then
       inst.components.finiteuses:SetPercent(1)
    end	
	if inst.components.finiteuses.current > 0 then
	   inst.components.weapon:SetDamage(TUNING.ICESWORD_DAMAGE)
	end
end

local function nouses(inst) 
	inst.components.weapon:SetDamage(0)
end

local function onload(inst) 
	if inst.components.weapon and inst.components.finiteuses then
		if inst.components.finiteuses.current > 0 then
			inst.components.weapon:SetDamage(TUNING.ICESWORD_DAMAGE)
		else
			inst.components.weapon:SetDamage(0)	
		end
	end
end

local function onattack(inst, owner, target)
    if math.random() < 0.5 and target.components.freezable then      -- 50%几率触发
       target.components.freezable:AddColdness(1)--增加的冰冻值
       target.components.freezable:SpawnShatterFX()	
    end
end


local function fn(sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("icesword")
    inst.AnimState:SetBuild("icesword")
    inst.AnimState:PlayAnimation("idle")
	
    inst:AddTag("sharp")


	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	--添加交易组件
	inst:AddComponent("trader")
	inst.components.trader.onaccept = OnGetItemFromPlayer

	--武器攻击力
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.ICESWORD_DAMAGE)
    inst.components.weapon:SetRange(1.1)
	inst.components.weapon.onattack = onattack

    --武器耐久
	onload(inst)
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.ICESWORD_USES)
    inst.components.finiteuses:SetUses(TUNING.ICESWORD_USES)
    inst.components.finiteuses:SetOnFinished(nouses)

    inst:AddComponent("inspectable")
	
	--[[添加工具组件
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 2)--]]
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/icesword.xml"
    
    inst:AddComponent("equippable")
	inst.components.equippable.walkspeedmult = 1.1
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    --添加右键施法组件	
	inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canusefrominventory = true
    inst.components.spellcaster.canonlyuseonlocomotorspvp = true
	inst.components.spellcaster.quickcast = true
    inst.components.spellcaster:SetSpellFn(SpawnIceFx)
	
	--添加时间组件
    inst:AddComponent("timer")
	
	--inst:AddComponent("combat")
	
    return inst
end

return Prefab( "common/inventory/icesword", fn, assets) 
