local assets=
{
	Asset("ANIM", "anim/firesword.zip"),
	Asset("ANIM", "anim/swap_firesword.zip"),
    Asset("ATLAS", "images/inventoryimages/firesword.xml"),
}

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_firesword", "swap_firesword_1")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end

local function OnGetItemFromPlayer(inst, giver, item)
	if item.prefab == "redgem" then
		inst.components.finiteuses:Use(-200)
elseif item.prefab == "charcoal" then
		inst.components.finiteuses:Use(-35)
elseif item.prefab == "goldnugget" then
		inst.components.finiteuses:Use(-25)		
	end	
	if inst.components.finiteuses:GetPercent() > 1 then
       inst.components.finiteuses:SetPercent(1)
    end	
	if inst.components.finiteuses.current > 0 then
	   inst.components.weapon:SetDamage(TUNING.FIRESWORD_DAMAGE)
	end
end

local function nouses(inst) 
	inst.components.weapon:SetDamage(0)
end

local function onload(inst) 
	if inst.components.weapon and inst.components.finiteuses then
		if inst.components.finiteuses.current > 0 then
			inst.components.weapon:SetDamage(TUNING.FIRESWORD_DAMAGE)
		else
			inst.components.weapon:SetDamage(0)	
		end
	end
end

	
local function onattack(inst, owner, target)
	if math.random() < 0.15 and target.components.burnable and target.sg and not target.sg:HasStateTag("frozen") and not target:HasTag("wall") and not target:HasTag("structure") and target.sg.sg.states.hit then
			target.sg:GoToState("hit")
			target.components.burnable:Ignite()
	if not target.liuxue then
     if target.components.health then
        target.components.health:StartRegen(-10, 0.5)	
	 end
	 target.liuxue = true
	 target:DoTaskInTime(1, function() target.liuxue = false target.components.health:StopRegen() end)
     end
	end
	if target.components.burnable and target.components.burnable:IsBurning() then
			target.components.burnable:Extinguish()
	end

	
	if target.components.sleeper and target.components.sleeper:IsAsleep() then
			target.components.sleeper:WakeUp()
	end
	if target.components.freezable then
			target.components.freezable:AddColdness(-1)
			
		if target.components.freezable:IsFrozen() then
				target.components.freezable:Unfreeze()            
		end
	end
	
    if math.random() < 0.25 then
	  if not inst.sanlian then
		inst:DoTaskInTime(2*FRAMES, function() inst.components.groundpounder:GroundPound() end)
		inst:DoTaskInTime(9*FRAMES, function() inst.components.groundpounder:GroundPound() end)		
		inst:DoTaskInTime(20*FRAMES, function() inst.components.groundpounder:GroundPound() end)
	  inst.sanlian  =true
	  inst:DoTaskInTime(10, function() inst.sanlian = false end) end	
	end
end

--[[local function abc(inst)          --冷却时间写法，搭配右键施法组件使用
local owner = inst.components.inventoryitem:GetGrandOwner()
if not inst.components.timer:TimerExists("iceswaord_cd")then --判定没有cd 
       inst.components.groundpounder:GroundPound()
	   inst.components.timer:StartTimer("iceswaord_cd", 20)  --进入冷却
	else --如果有CD 那么
local timeleft = inst.components.timer:GetTimeLeft("iceswaord_cd")
      timeleft = math.ceil(timeleft * 10) / 10	 --获取冷却时间
    if owner.components.talker then
       owner.components.talker:Say("武器冷却还需要 "..timeleft.." 秒")
     end
end 
end--]]

local function fn(sim)
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
	
    inst.AnimState:SetBank("firesword")
    inst.AnimState:SetBuild("firesword")
    inst.AnimState:PlayAnimation("idle")
	
    inst:AddTag("sharp")


	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst:AddComponent("trader")
	inst.components.trader.onaccept = OnGetItemFromPlayer

	--武器攻击力
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(TUNING.FIRESWORD_DAMAGE)
    inst.components.weapon:SetRange(1.1)
	inst.components.weapon.onattack = onattack

    --武器耐久
	onload(inst) 
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(TUNING.FIRESWORD_USES)
    inst.components.finiteuses:SetUses(TUNING.FIRESWORD_USES) 
    inst.components.finiteuses:SetOnFinished(nouses)

    inst:AddComponent("inspectable")
	
	--[[添加工具组件
	inst:AddComponent("tool")
    inst.components.tool:SetAction(ACTIONS.CHOP, 2)--]]
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/firesword.xml"
    
    inst:AddComponent("equippable")
	inst.components.equippable.walkspeedmult = 1.1
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
	
--[[	inst:AddComponent("spellcaster")
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster.canusefrominventory = true
    inst.components.spellcaster.canonlyuseonlocomotorspvp = true
	inst.components.spellcaster.quickcast = true
    
    inst.components.spellcaster:SetSpellFn(abc)
    inst:AddComponent("timer")--]]
	
	
	--添加组件
	inst:AddComponent("groundpounder")
	inst.components.groundpounder.numRings = 2
	--inst.components.groundpounder.burner = true
    inst.components.groundpounder.groundpoundfx = "firesplash_fx"
    inst.components.groundpounder.groundpounddamagemult = 0.5
    inst.components.groundpounder.groundpoundringfx = "firering_fx"
	--inst.components.groundpounder.destructionRings = 2
	function inst.components.groundpounder:DestroyPoints(points, breakobjects, dodamage)
		local getEnts = breakobjects or dodamage
		local map = TheWorld.Map
		for k, v in pairs(points) do
			if getEnts then
				local ents = TheSim:FindEntities(v.x, v.y, v.z, 3, nil, self.noTags)
				if #ents > 0 then
					if breakobjects then
						for i, v2 in ipairs(ents) do
							if v2 ~= self.inst and v2:IsValid() then
								if self.destroyer and
									v2.components.workable ~= nil and
									v2.components.workable:CanBeWorked() and
									v2.components.workable.action ~= ACTIONS.NET then
									v2.components.workable:Destroy(self.inst)
								end
								if v2:IsValid() and 
									not v2:IsInLimbo() and 
									self.burner and
									v2.components.fueled == nil and
									v2.components.burnable ~= nil and
									not v2.components.burnable:IsBurning() and
									not v2:HasTag("burnt") then
									v2.components.burnable:Ignite()
								end
							end
						end
					end
					if dodamage then
						for i, v2 in ipairs(ents) do
							if v2 ~= self.inst and
								v2:IsValid() and
								v2.components.health ~= nil and
								not v2.components.health:IsDead() and 
								--self.inst.components.combat:CanTarget(v2) and 
								not (v2.components.follower and v2.components.follower.leader == inst ) and 
								(TheNet:GetPVPEnabled() or not v2:HasTag("player"))
								and not v2:HasTag("wall")
								and not v2:HasTag("companion")
								and (
									v2:HasTag("monster")	--怪物
									or v2:HasTag("epic")	--boss
									or v2.components.combat and v2.components.combat.target and v2.components.combat.target:HasTag("player") --要伤害玩家
									or TheNet:GetPVPEnabled() and v2:HasTag("player") --敌对的队友
								)
								then
								if v2.sg and v2.sg.sg and v2.sg.sg.states and v2.sg.sg.states["hit"] then
									v2.sg:GoToState("hit")
								end
								v2.components.health:DoFireDamage(60, nil, true)
								v2.components.combat:GetAttacked(inst, 60)
								
								
							end
						end
					end
				end
			end
			if map:IsPassableAtPoint(v:Get()) then
				SpawnPrefab(self.groundpoundfx).Transform:SetPosition(v.x, 0, v.z)
			end
		end
	end
	
	--inst:AddComponent("combat")
	
    return inst
end

return Prefab( "common/inventory/firesword", fn, assets) 
