local assets =
{
	Asset("ANIM", "anim/laxative.zip"),
	Asset("IMAGE", "images/inventoryimages/laxative.tex"),
	Asset("ATLAS", "images/inventoryimages/laxative.xml")
}

local function laxative(inst, eater)
	if eater and eater.components.hunger and eater.components.health and eater.components.sanity then
		eater.components.hunger:DoDelta(-5)
		eater.components.health:DoDelta(1)
		eater.components.sanity:DoDelta(-(math.random(5,10)))
		SpawnPrefab("poop").Transform:SetPosition(eater.Transform:GetWorldPosition())
		if eater.sg and eater.sg.sg.states.hit then
			eater.sg:GoToState("hit")
		end
	end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("spider_gland_salve")
    inst.AnimState:SetBuild("laxative")
    inst.AnimState:PlayAnimation("idle")
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst.entity:SetPristine()
	
	inst:AddComponent("inventoryitem")
	inst.replica.inventoryitem:SetImage("healingsalve")
    --inst.components.inventoryitem.atlasname = "images/inventoryimages/laxative.xml"
    
    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
	
	inst:AddTag("show_spoilage")

	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_MED)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
	MakeHauntableLaunchAndPerish(inst)
	
	inst:AddComponent("edible")
	inst.components.edible:SetOnEatenFn(laxative)
    
    return inst
end

return Prefab( "common/inventory/laxative", fn, assets) 