
local function ondiscarded(inst)
    inst.components.finiteuses:Use()
end

local function onusedup(inst)
    SpawnPrefab("ground_chunks_breaking").Transform:SetPosition(inst.Transform:GetWorldPosition())
    inst:Remove()
end

local function MakeSaddle(name, data)
    local assets = {
        Asset("ANIM", "anim/saddle_moon.zip"),
        Asset("ATLAS", "images/inventoryimages/saddle_moon.xml"),
        Asset("IMAGE", "images/inventoryimages/saddle_moon.tex"),
    }

    local function fn(Sim)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBank("saddlebasic")
        inst.AnimState:SetBuild(name)
        inst.AnimState:PlayAnimation("idle")

        inst.mounted_foleysound = "dontstarve/beefalo/saddle/"..data.foley

        inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end

        inst:AddComponent("inspectable")
        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.atlasname = "images/inventoryimages/saddle_moon.xml"
        inst.components.inventoryitem.imagename = "saddle_moon"
        
        inst:AddComponent("saddler")
        inst.components.saddler:SetBonusDamage(data.bonusdamage)
        inst.components.saddler:SetBonusSpeedMult(data.speedmult)
        inst.components.saddler:SetSwaps(name, "swap_saddle")
        inst.components.saddler:SetDiscardedCallback(ondiscarded)

        inst:AddComponent("finiteuses")
        inst.components.finiteuses:SetMaxUses(data.uses)
        inst.components.finiteuses:SetUses(data.uses)
        inst.components.finiteuses:SetOnFinished(onusedup)

        MakeHauntableLaunch(inst)

        return inst
    end

    return Prefab(name, fn, assets)
end

local data = {
    moon = {
        bonusdamage = TUNING.SADDLE_MOON_BONUS_DAMAGE,
        foley = "war_foley",
        uses = TUNING.SADDLE_MOON_USES,
        speedmult = TUNING.SADDLE_MOON_SPEEDMULT,
    },
}

return  MakeSaddle("saddle_moon", data.moon)
