local Assets =
{
	Asset("ANIM", "anim/dragonbulb.zip"),
  Asset("ATLAS", "images/inventoryimages/dragonbulb.xml"),
}

local dragonbulb_recipe = 
{   
  name = "dragonbulb",
  --test = function(cooker, names, tags) return names.twigs >= 4 end,
  priority = 10,
  weight = 1,
  foodtype = "VEGGIE",
  health = TUNING.HEALING_HUGE,
  hunger = TUNING.CALORIES_TINY,
  perishtime = TUNING.PERISH_SUPERSLOW,
  sanity = -100,
  --cooktime = 2, --1=~20sec
}

local function MakePreparedFood(data)
    local function fn(Sim)
        local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)

        inst.AnimState:SetBuild("dragonbulb")
        inst.AnimState:SetBank("dragonbulb")
        inst.AnimState:PlayAnimation("idle")

        inst:AddTag("preparedfood")

        inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end

        inst:AddComponent("edible")
        inst.components.edible.healthvalue = data.health
        inst.components.edible.hungervalue = data.hunger
        inst.components.edible.foodtype = FOODTYPE.ROUGHAGE
        --inst.components.edible.sanityvalue = data.sanity or 0
        --inst.components.edible.temperaturedelta = data.temperature or 0
        --inst.components.edible.temperatureduration = data.temperatureduration or 0

        inst:AddComponent("inspectable")
        inst.wet_prefix = data.wet_prefix
        
        inst:AddComponent("inventoryitem")
        inst.components.inventoryitem.atlasname = "images/inventoryimages/dragonbulb.xml"
        inst.components.inventoryitem.imagename = "dragonbulb"

        inst:AddComponent("stackable")
        inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

        --[[
        inst:AddComponent("perishable")
        inst.components.perishable:SetPerishTime(data.perishtime or TUNING.PERISH_SLOW)
        inst.components.perishable:StartPerishing()
        inst.components.perishable.onperishreplacement = "spoiled_food"]]--

        if data.tags then
            for i,v in pairs(data.tags) do
                inst:AddTag(v)
            end
        end

        MakeSmallBurnable(inst)
        MakeSmallPropagator(inst)
        MakeHauntableLaunchAndPerish(inst)
        AddHauntableCustomReaction(inst, function(inst, haunter)
            --#HAUNTFIX
            --if math.random() <= TUNING.HAUNT_CHANCE_SUPERRARE then
                --if inst.components.burnable and not inst.components.burnable:IsBurning() then
                    --inst.components.burnable:Ignite()
                    --inst.components.hauntable.hauntvalue = TUNING.HAUNT_MEDIUM
                    --inst.components.hauntable.cooldown_on_successful_haunt = false
                    --return true
                --end
            --end
            return false
        end, true, false, true)
        ---------------------        

        inst:AddComponent("bait")

        ------------------------------------------------
        inst:AddComponent("tradable")
        
        ------------------------------------------------  

        return inst
    end

    return Prefab(data.name, fn, Assets)
end

return MakePreparedFood(dragonbulb_recipe)
