local TUNING = GLOBAL.TUNING
local FRAMES = GLOBAL.FRAMES
local FUELTYPE = GLOBAL.FUELTYPE
local SpawnPrefab = GLOBAL.SpawnPrefab
local ErodeAway = GLOBAL.ErodeAway

AddRecipe("diviningrod", {Ingredient("twigs", 1), Ingredient("nightmarefuel", 4), Ingredient("gears", 1)}, GLOBAL.RECIPETABS.SCIENCE, GLOBAL.TECH.LOST)

if not GLOBAL.TheNet:GetIsServer() then return end

local BLUEPRINT_KEEPERS =
{
	{ prefab = "bishop", chance = 0.3 },
	{ prefab = "knight", chance = 0.1 },
	
	{ prefab = "bishop_nightmare", chance = 0.6 },
	{ prefab = "knight_nightmare", chance = 0.2 },
}

for k = 1, 3 do
	table.insert(BLUEPRINT_KEEPERS, { prefab = "chessjunk"..tostring(k), chance = 0.1 })
end

for _,v in pairs(BLUEPRINT_KEEPERS) do
	AddPrefabPostInit(v.prefab, function(inst)
		if inst.components.lootdropper ~= nil then
			inst.components.lootdropper:AddChanceLoot("diviningrod_blueprint", v.chance or 1)
		end
	end)
end

AddPrefabPostInit("diviningrod", function(inst)
    local EFFECTS = { hot = "dr_hot_loop", warmer = "dr_warmer_loop", warm = "dr_warm_loop_2", cold = "dr_warm_loop_1" }
	
	local CHANNELS =
	{
		{ tags = { "chester_eyebone", "chester" }, targets = { chester_eyebone = true, chester = true }, scale = 0.5, bank = "chester", build = "chester_build", idle = "sleep_loop" },
		{ tags = { "hutch_fishbowl", "hutch" }, targets = { hutch_fishbowl = true, hutch = true }, scale = 0.45, bank = "hutch", build = "hutch_build", idle = "sleep_loop", hide = "fx_lure_light" },
		{ tags = { "epic", "deerclops" }, targets = { deerclops = true }, scale = 0.6, idle = "boss_deerclops" },
		{ tags = { "epic", "moose", "mossling" }, targets = { moose = true, mossling = true }, scale = 0.7, idle = "boss_moose" },
		{ tags = { "epic", "bearger" }, targets = { bearger = true }, scale = 0.7 },
		{ tags = { "epic", "dragonfly" }, targets = { dragonfly = true }, scale = 0.65, idle = "boss_dragonfly" },
		{ tags = { "epic", "bee", "event_trigger" }, targets = { beequeen = true, beequeenhivegrown = true }, scale = 0.65, idle = "boss_beequeen" },
		{ tags = { "epic", "toadstool" }, targets = { toadstool = true, toadstool_dark = true }, scale = 0.65, idle = "boss_toadstool" },
	  --{ tags = { "pickable" }, targets = { mandrake_planted = true, mandrake_active = true }, scale = 0.5, bank = "mandrake", idle = "object" },
	}
	
	if inst.num == nil then
		inst.num = 1
	end
	
	local function Link()
		return CHANNELS[inst.num]
	end
	
	--------------------------------------------------------------------------
	
	local function FindClosestPart(inst)
    	inst.tracking_parts = {}
		local x, y, z = inst.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, TUNING.DIVINING_MAXDIST, nil, nil, Link().tags)
    	if #ents > 0 then
        	for k,v in pairs(ents) do
            	if Link().targets[v.prefab] then
            		table.insert(inst.tracking_parts, v)
				end
        	end
		end

    	if inst.tracking_parts then
        	local closest = nil
        	local closest_dist = nil
        	for k,v in pairs(inst.tracking_parts) do
            	if v:IsValid() and not v:IsInLimbo() then
                	local dist = v:GetDistanceSqToInst(inst)
                	if not closest_dist or dist < closest_dist then
                    	closest = v
                    	closest_dist = dist
                	end
            	end
        	end

        	return closest
    	end
	end
	
	local function CheckTargetPiece(inst)
    	if inst.components.equippable:IsEquipped() and inst.components.inventoryitem.owner then		
			if GLOBAL.TheNet:IsDedicated() then
            	inst.SoundEmitter:KillSound("ping")
        	end
			
			local intensity, closeness, fxname, nextpingtime = 0, nil, nil, TUNING.DIVINING_DEFAULTPING
    	    local target = FindClosestPart(inst)
    	    if target ~= nil then
    	        local distsq = inst.components.inventoryitem.owner:GetDistanceSqToInst(target)
    	        intensity = math.max(0, 1 - (distsq/(TUNING.DIVINING_MAXDIST*TUNING.DIVINING_MAXDIST) ))
        	    for k,v in ipairs(TUNING.DIVINING_DISTANCES) do
        	        closeness = v
        	        fxname = EFFECTS[v.describe]

        	        if v.maxdist and distsq <= v.maxdist*v.maxdist then
        	            nextpingtime = closeness.pingtime
        	            break
        	        end
        	    end
        	end

        	if closeness ~= inst.closeness then
        	    inst.closeness = closeness
            	local desc = inst.components.inspectable:GetDescription(inst.components.inventoryitem.owner)
            	if desc then
            	    inst.components.inventoryitem.owner.components.talker:Say(desc)
            	end
        	end

        	if fxname ~= nil then
            	inst.fx = SpawnPrefab(fxname)
            	inst.fx.entity:AddFollower()
            	inst.fx.Follower:FollowSymbol(inst.components.inventoryitem.owner.GUID, "swap_object", 80, -320, 0)
        	end

			inst.SoundEmitter:PlaySound("dontstarve/common/diviningrod_ping", "ping")
        	inst.SoundEmitter:SetParameter("ping", "intensity", intensity)
        	inst.task = inst:DoTaskInTime(nextpingtime or 1, CheckTargetPiece)
    	end 
	end
	
	--------------------------------------------------------------------------
	
	local function ShowIndicator(inst, owner)		
		if not inst.components.equippable:IsEquipped() then
			return
		elseif owner == nil then
			owner = inst.components.inventoryitem.owner
		end
		
		if inst.badge ~= nil then
			ErodeAway(inst.badge, 0.25)
			inst.badge = nil
		end
		inst.badge = SpawnPrefab("nightmarefuel")
		
		local badge, CH = inst.badge, Link()
		local scale, bank, build, idle, hide = CH.scale or 1, CH.bank or "winter_ornaments", CH.build or CH.bank or "winter_ornaments", CH.idle or "boss_bearger", CH.hide
		
		badge:AddTag("FX"); badge.Physics:SetMass(0); badge.Transform:SetScale(scale, scale, scale)
				
		badge.AnimState:SetBank(bank); badge.AnimState:SetBuild(build); badge.AnimState:PlayAnimation(idle, true)
		badge.AnimState:SetBloomEffectHandle("shaders/anim.ksh"); if hide ~= nil then badge.AnimState:Hide(hide) end
						
		badge.entity:AddFollower(); badge.Follower:FollowSymbol(owner.GUID, "swap_object", 80, -390, 0) --110, -430
		
		local time_to_erode = 1.5
		badge:DoTaskInTime(time_to_erode, ErodeAway)
		badge:DoTaskInTime(time_to_erode + 0.3, function() badge.AnimState:ClearBloomEffectHandle() end)
	end
	
	local function SwitchChannel(inst)		
		if inst.num < #CHANNELS then
			inst.num = inst.num + 1
		else
			inst.num = 1
		end
			
		ShowIndicator(inst)
				
		if inst.task ~= nil then
			inst.task:Cancel()
			inst.task = nil
		end
		inst.task = inst:DoTaskInTime(1, CheckTargetPiece)
		
		inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_pulse")		
    end
	
	local function OnUse(inst)
		local owner = inst.components.inventoryitem.owner		
		if owner ~= nil and owner:HasTag("player") then			
			if owner.sg:HasStateTag("idle") or owner.sg:HasStateTag("channeling") then
				owner.sg:GoToState("doshortaction")
			end			
			inst:DoTaskInTime(6 * FRAMES, SwitchChannel)
        end
		
		inst.components.useableitem:StopUsingItem()
	end
	
	inst:AddComponent("useableitem")
    inst.components.useableitem:SetOnUseFn(OnUse)
	
	--------------------------------------------------------------------------

	local function OnEquip(inst, owner)
    	owner.AnimState:Show("ARM_carry")
    	owner.AnimState:Hide("ARM_normal")
    	owner.AnimState:OverrideSymbol("swap_object", "swap_diviningrod", "swap_diviningrod")
		
    	if not inst.disabled then
        	inst.closeness = nil 
        	inst.tracking_parts = nil       
        	inst.task = inst:DoTaskInTime(1, CheckTargetPiece)
    	end
		
		ShowIndicator(inst, owner)
		
		inst.components.fueled:StartConsuming()
	end
	
	local OldOnUnequip = inst.components.equippable.onunequipfn
	local function OnUnequip(inst, owner) 
		OldOnUnequip(inst, owner)
				
		for _,v in pairs({ inst.fx, inst.badge }) do
			if v ~= nil then
				v:Remove()
			end
		end
				
		inst.components.fueled:StopConsuming()
	end
	
	inst.components.equippable:SetOnEquip(OnEquip)
	inst.components.equippable:SetOnUnequip(OnUnequip)
	
	--------------------------------------------------------------------------
	
	local function OnDepleted(inst)
		local owner = inst.components.inventoryitem.owner
		if owner ~= nil then
			owner.SoundEmitter:PlaySound("dontstarve/creatures/bishop/liedown")
			owner:PushEvent("toolbroke", { tool = inst })
			SpawnPrefab("sparks").Transform:SetPosition(owner.Transform:GetWorldPosition())
		end
								
		inst:Remove()
	end
	
	local function ToggleJaw(inst)
		local comp = inst.components
		comp.fueled.accepting = not comp.fueled.accepting
		comp.inventoryitem.canbepickedup = not comp.inventoryitem.canbepickedup
	end
	
	local function StickFX(inst, owner, prefab, scale, x, z)
		local fx = SpawnPrefab(prefab)
		fx.Transform:SetScale(scale, scale, scale); fx.entity:AddFollower()
    					
		local ID, symbol = owner and owner.GUID or inst.GUID, owner and "swap_object" or "swap_diviningrod01"
		fx.Follower:FollowSymbol(ID, symbol, x, z, 0)
	end
	
	local function OnTakeFuel(inst)
    	local owner = inst.components.inventoryitem.owner
		if inst.components.fueled:GetPercent() > 0.99 then 
			inst.components.hauntable:DoHaunt()
			ToggleJaw(inst); inst:DoTaskInTime(5, ToggleJaw)
			
			if owner ~= nil and owner:HasTag("player") then
				owner.components.inventory:DropItem(inst, true, true)
				owner.sg:GoToState("repelled")
			end
			
			inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_pulled")
			StickFX(inst, nil, "shock_fx", 0.7, 80, -240)
		else
			inst.SoundEmitter:PlaySound("dontstarve/common/teleportato/teleportato_under")
			StickFX(inst, owner, "shadow_shield"..tostring(math.random(6)), 0.45, 70, -220)
		end
	end
	
	inst:AddComponent("fueled")
	inst.components.fueled.fueltype = FUELTYPE.NIGHTMARE
    inst.components.fueled:InitializeFuelLevel(TUNING.TOTAL_DAY_TIME * 1.5)
	inst.components.fueled:SetDepletedFn(OnDepleted)
	inst.components.fueled:SetTakeFuelFn(OnTakeFuel)
	inst.components.fueled.accepting = true
	
	--------------------------------------------------------------------------
	
	inst:RemoveTag("irreplaceable")
	
	local function OnSave(inst, data)
    	data.num = inst.num
	end

	local function OnLoad(inst, data)
    	inst.num = data and data.num or 1
	end
	
	inst.OnSave = OnSave
    inst.OnLoad = OnLoad
end)