require "prefabutil"

local function makeobstacle(inst)

    inst.Physics:SetCollisionGroup(COLLISION.OBSTACLES) 
    inst.Physics:ClearCollisionMask()
    inst.Physics:SetMass(0)
    inst.Physics:CollidesWith(COLLISION.ITEMS)
    inst.Physics:CollidesWith(COLLISION.CHARACTERS)
    inst.Physics:SetActive(true)
    TheWorld.Pathfinder:AddWall(inst.Transform:GetWorldPosition())
end

local function disablephysics(inst)
    inst.Physics:SetActive(false)
end

local function clearobstacle(inst)
    inst:DoTaskInTime(2 * FRAMES, disablephysics)
    TheWorld.Pathfinder:RemoveWall(inst.Transform:GetWorldPosition())
end

local function resolveanimtoplay(percent)
    local anim_to_play = nil
    if percent <= 0 then
        anim_to_play = "0"
    elseif percent <= .4 then
        anim_to_play = "1_4"
    elseif percent <= .5 then
        anim_to_play = "1_2"
    elseif percent < 1 then
        anim_to_play = "3_4"
    else
        anim_to_play = "1"
    end
    return anim_to_play
end

local function onhealthchange(inst, old_percent, new_percent)
		if old_percent <= 0 and new_percent > 0 then inst:RemoveTag("broken") makeobstacle(inst) end
		if old_percent > 0 and new_percent <= 0 then inst:AddTag("broken") clearobstacle(inst) end
		local anim_to_play = resolveanimtoplay(new_percent)
		if new_percent > 0 and not inst.components.wallgates:IsOpen() then
			inst.AnimState:PlayAnimation("0")	
		elseif new_percent > 0 and inst.components.wallgates:IsOpen() then
			inst.AnimState:PlayAnimation(anim_to_play.."_hit")		
			inst.AnimState:PushAnimation(anim_to_play, false)		
		else
			inst.AnimState:PlayAnimation(anim_to_play)		
		end
end

	local function openwallremote(inst)
	
	   local name = nil
	   if inst.entity:HasTag("grass") then 
	   name = "straw"
	   elseif inst.entity:HasTag("wood") then 
       name = "wood"
	   elseif inst.entity:HasTag("stone") then
	   name = "stone"
	   end
	   local var = inst.components.health:GetPercent()
	   if var <= 0 then
	   inst.SoundEmitter:PlaySound("dontstarve/common/destroy_"..name)	
	   inst.components.wallgates.isopen = false
	   inst.AnimState:PushAnimation("0")
	   elseif var <= .4 then
	   inst.components.wallgates.isopen = true
	   inst.AnimState:PlayAnimation("1_4")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   makeobstacle(inst)
	   elseif var <= .5 then
	   inst.components.wallgates.isopen = true
	   inst.AnimState:PlayAnimation("1_2")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   makeobstacle(inst)
	   elseif var <= .9 then
	   inst.components.wallgates.isopen = true
	   inst.AnimState:PlayAnimation("3_4")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   makeobstacle(inst)
	   else
	   inst.AnimState:PlayAnimation("1")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   inst.components.wallgates.isopen = true
	   makeobstacle(inst)
	   end
	end
	
	local function openwall(inst)
		local x,y,z = inst.Transform:GetWorldPosition()
		local nearbywallgates = TheSim:FindEntities(x,y,z, 2, {"wallgate"} )
		for i = 1, #nearbywallgates do
			if nearbywallgates[i].components.wallgates.isopen == false and not nearbywallgates[i]:HasTag("broken") then
			openwallremote(nearbywallgates[i])
			end
		end
		
	   local name = nil
	   if inst.entity:HasTag("grass") then 
	   name = "straw"
	   elseif inst.entity:HasTag("wood") then 
       name = "wood"
	   elseif inst.entity:HasTag("stone") then
	   name = "stone"
	   end
	   local var = inst.components.health:GetPercent()
	   if var <= 0 then
	   inst.SoundEmitter:PlaySound("dontstarve/common/destroy_"..name)	
	   inst.components.wallgates.isopen = false
	   inst.AnimState:PushAnimation("0")
	   elseif var <= .4 then
	   inst.components.wallgates.isopen = true
	   inst.AnimState:PlayAnimation("1_4")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   makeobstacle(inst)
	   elseif var <= .5 then
	   inst.components.wallgates.isopen = true
	   inst.AnimState:PlayAnimation("1_2")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   makeobstacle(inst)
	   elseif var <= .9 then
	   inst.components.wallgates.isopen = true
	   inst.AnimState:PlayAnimation("3_4")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   makeobstacle(inst)
	   else
	   inst.AnimState:PlayAnimation("1")
	   inst.SoundEmitter:PlaySound("dontstarve/common/place_structure_"..name)
	   inst.components.wallgates.isopen = true
	   makeobstacle(inst)
	   end
	end
	
	local function closewallremote(inst, data)
		local name = nil
		if inst.entity:HasTag("grass") then 
		name = "straw"
		elseif inst.entity:HasTag("wood") then 
		name = "wood"
		elseif inst.entity:HasTag("stone") then
		name = "stone"
		end
	    inst.components.wallgates.isopen = false
	    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_"..name)		
	    inst.AnimState:PlayAnimation("0")
	    clearobstacle(inst)
	end
	
	local function closewall(inst, data)
	
		local x,y,z = inst.Transform:GetWorldPosition()
		local nearbywallgates = TheSim:FindEntities(x,y,z, 2, {"wallgate"} )
		for i = 1, #nearbywallgates do
			if nearbywallgates[i].components.wallgates.isopen == true and not nearbywallgates[i]:HasTag("broken") then
			closewallremote(nearbywallgates[i])
			end
		end
		
		local name = nil
		if inst.entity:HasTag("grass") then 
		name = "straw"
		elseif inst.entity:HasTag("wood") then 
		name = "wood"
		elseif inst.entity:HasTag("stone") then
		name = "stone"
		end
	    inst.components.wallgates.isopen = false
	    inst.SoundEmitter:PlaySound("dontstarve/common/destroy_"..name)		
	    inst.AnimState:PlayAnimation("0")
	    clearobstacle(inst)
	end

local function onload(inst)
    makeobstacle(inst)
    if inst.components.health:GetPercent() <= 0 then
		inst:AddTag("broken")
        clearobstacle(inst)
    end
end

function MakeMechType(data)

	local assets =
	{
		Asset("ANIM", "anim/mech.zip"),
		Asset("ANIM", "anim/mech_"..data.name..".zip"),
		Asset("ATLAS", "images/inventoryimages/mech_"..data.name.."_item.xml"),
	}

	local function ondeploywall(inst, pt, deployer)
		local mech = SpawnPrefab("mech_"..data.name) 
		if mech ~= nil then 
			pt = Vector3(math.floor(pt.x) + .5, 0, math.floor(pt.z) + .5)
			mech.Physics:SetCollides(false)
			mech.Physics:Teleport(pt:Get())
			mech.Physics:SetCollides(true)
			inst.components.stackable:Get():Remove()

	    	TheWorld.Pathfinder:AddWall(pt:Get())
			openwall(mech)
		end 		
	end

	local function onhammered(inst, worker)
		if data.maxloots and data.loot then
			local num_loots = math.max(1, math.floor(data.maxloots*inst.components.health:GetPercent()))
			for k = 1, num_loots do
				inst.components.lootdropper:SpawnLootPrefab(data.loot)
			end
		end		

		SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())

		if data.destroysound then
			inst.SoundEmitter:PlaySound(data.destroysound)		
		end
		SpawnPrefab("gears").Transform:SetPosition(inst.Transform:GetWorldPosition())
		inst:Remove()
	end

	local function itemfn()

		local inst = CreateEntity()

        inst.entity:AddTransform()
        inst.entity:AddAnimState()
        inst.entity:AddNetwork()

        MakeInventoryPhysics(inst)

        inst:AddTag("wallbuilder")

		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("mech_"..data.name)
		inst.AnimState:PlayAnimation("idle")

        if not TheWorld.ismastersim then
            return inst
        end

        inst.entity:SetPristine()

        inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_MEDITEM

		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.atlasname = "images/inventoryimages/mech_"..data.name.."_item.xml"
	
		if data.flammable then
			MakeSmallBurnable(inst, TUNING.MED_BURNTIME)
			MakeSmallPropagator(inst)

			inst:AddComponent("fuel")
			inst.components.fuel.fuelvalue = TUNING.SMALL_FUEL
		end

		inst:AddComponent("deployable")
		inst.components.deployable.ondeploy = ondeploywall
		inst.components.deployable:SetDeployMode(DEPLOYMODE.WALL)
	
		MakeHauntableLaunch(inst)

		return inst
	end

	local function onhit(inst)
		if data.destroysound then
			inst.SoundEmitter:PlaySound(data.destroysound)		
		end

		local healthpercent = inst.components.health:GetPercent()
		local anim_to_play = resolveanimtoplay(healthpercent)
		if healthpercent > 0 then
			inst.AnimState:PlayAnimation(anim_to_play.."_hit")		
			inst.AnimState:PushAnimation(anim_to_play, false)	
		end	

	end

	local function onrepaired(inst)
		if data.buildsound then
			inst.SoundEmitter:PlaySound(data.buildsound)		
		end
		makeobstacle(inst)
	end

	local function fn()
		local inst = CreateEntity()

		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
        inst.entity:AddNetwork()

        MakeObstaclePhysics(inst, .5)

        inst:AddTag("wall")
		inst:AddTag("wallgate")
		inst.Physics:SetDontRemoveOnSleep(true)
        inst.AnimState:SetBank("wall")
        inst.AnimState:SetBuild("mech_"..data.name)
        inst.AnimState:PlayAnimation("1_2", false)
		inst.owner = nil
        for i, v in ipairs(data.tags) do
            inst:AddTag(v)
        end

        MakeSnowCoveredPristine(inst)

        if not TheWorld.ismastersim then
            return inst
        end

        inst.entity:SetPristine()

		inst:AddComponent("inspectable")
		inst:AddComponent("lootdropper")

		inst:AddComponent("repairable")
        if data.name == "ruins" then
		    inst.components.repairable.repairmaterial = MATERIALS.THULECITE
        else
		    inst.components.repairable.repairmaterial = data.name
        end
		inst.components.repairable.onrepaired = onrepaired

		inst:AddComponent("combat")
		inst.components.combat.onhitfn = onhit

        inst:AddComponent("health")
		inst.components.health:SetMaxHealth(data.maxhealth)
		inst.components.health:SetCurrentHealth(data.maxhealth / 2)
		inst.components.health.ondelta = onhealthchange
		inst.components.health.nofadeout = true
		inst.components.health.canheal = false
		if data.name == "moonrock" then
			inst.components.health:SetAbsorbAmountFromPlayer(TUNING.MOONROCKWALL_PLAYERDAMAGEMOD)
		end
		inst:AddTag("noauradamage")

		inst:AddComponent("wallgates")
		inst.components.wallgates.openwallfn = openwall
        inst.components.wallgates.closewallfn = closewall
		
		if data.flammable then
			MakeLargeBurnable(inst)
			MakeLargePropagator(inst)
			inst.components.burnable.flammability = .5

			--lame!
			if data.name == MATERIALS.WOOD then
				inst.components.propagator.flashpoint = 30+math.random()*10			
			end
		else
			inst.components.health.fire_damage_scale = 0
		end

		if data.buildsound then
			inst.SoundEmitter:PlaySound(data.buildsound)		
		end

		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		if data.name == "moonrock" then
			inst.components.workable:SetWorkLeft(TUNING.MOONROCKWALL_WORK)
		else
			inst.components.workable:SetWorkLeft(3)
		end
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onhit) 

		MakeHauntableWork(inst)

	    inst.OnLoad = onload
	    inst.OnRemoveEntity = clearobstacle

		MakeSnowCovered(inst)

		return inst
	end

	return Prefab( "common/mech_"..data.name, fn, assets),
		   Prefab( "common/mech_"..data.name.."_item", itemfn, assets, {"mech_"..data.name, "mech_"..data.name.."_placer"}),
		   MakePlacer("common/mech_"..data.name.."_item_placer", "wall", "mech_"..data.name, "1_2", false, false, true) 
end

local mechprefabs = {}

--6 rock, 8 wood, 4 straw
--NOTE: Stacksize is now set in the actual recipe for the item.
local mechdata = {
			{name = MATERIALS.STONE, tags={"stone"}, loot = "rocks", maxloots = 2, maxhealth=TUNING.STONEWALL_HEALTH, paintable = true, buildsound="dontstarve/common/place_structure_stone", destroysound="dontstarve/common/destroy_stone"},
			{name = MATERIALS.WOOD, tags={"wood"}, loot = "log", maxloots = 2, maxhealth=TUNING.WOODWALL_HEALTH, flammable = true, buildsound="dontstarve/common/place_structure_wood", destroysound="dontstarve/common/destroy_wood"},
			{name = MATERIALS.HAY, tags={"grass"}, loot = "cutgrass", maxloots = 2, maxhealth=TUNING.HAYWALL_HEALTH, flammable = true, buildsound="dontstarve/common/place_structure_straw", destroysound="dontstarve/common/destroy_straw"},
			{name = "ruins", tags={"stone", "ruins"}, loot = "thulecite_pieces", maxloots = 2, maxhealth=TUNING.RUINSWALL_HEALTH, buildsound="dontstarve/common/place_structure_stone", destroysound="dontstarve/common/destroy_stone"},
			{name = "moonrock", tags={"stone", "moonrock"}, loot = "moonrocknugget", maxloots = 2, maxhealth=TUNING.MOONROCKWALL_HEALTH, paintable = true, buildsound="dontstarve/common/place_structure_stone", destroysound="dontstarve/common/destroy_stone"},
        }

for k,v in pairs(mechdata) do
	local mech, item, placer = MakeMechType(v)
	table.insert(mechprefabs, mech)
	table.insert(mechprefabs, item)
	table.insert(mechprefabs, placer)
end

return unpack(mechprefabs)