
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {
    Asset("SCRIPT", "scripts/prefabs/player_common.lua"),
}
local prefabs = 
{
}

-- Custom starting items
local start_inv = {

}



-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when reviving from ghost (optional)
	inst.components.locomotor:SetExternalSpeedMultiplier(inst, "nappa_speed_mod", 1.3)
end

local function onbecameghost(inst)
	-- Remove speed modifier when becoming a ghost
   inst.components.locomotor:RemoveExternalSpeedMultiplier(inst, "nappa_speed_mod", 1)
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    inst:ListenForEvent("ms_becameghost", onbecameghost)

    if inst:HasTag("playerghost") then
        onbecameghost(inst)
    else
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "nappa.tex" )
end



-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "wolfgang"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	

	-- Stats	
	inst.components.health:SetMaxHealth(250)
	inst.components.hunger:SetMax(300)
	inst.components.sanity:SetMax(100)
	
	
   
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1.5
	
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 2.5 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	--Not afraid of monsters
	inst.components.sanity.neg_aura_mult = 0
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
	
	

	
	
end

return MakePlayerCharacter("nappa", prefabs, assets, common_postinit, master_postinit, start_inv)
