PrefabFiles = {
	"nappa",
	"nappa_none",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/nappa.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/nappa.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/nappa.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/nappa.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/nappa_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/nappa_silho.xml" ),

    Asset( "IMAGE", "bigportraits/nappa.tex" ),
    Asset( "ATLAS", "bigportraits/nappa.xml" ),
	
	Asset( "IMAGE", "images/map_icons/nappa.tex" ),
	Asset( "ATLAS", "images/map_icons/nappa.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_nappa.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_nappa.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_nappa.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_nappa.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_nappa.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_nappa.xml" ),
	
	Asset( "IMAGE", "images/names_nappa.tex" ),
    Asset( "ATLAS", "images/names_nappa.xml" ),
	
    Asset( "IMAGE", "bigportraits/nappa_none.tex" ),
    Asset( "ATLAS", "bigportraits/nappa_none.xml" ),

}

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

local CASTFIRE = AddAction("CASTFIRE", "Destroy!", function(act)    
local projectile = GLOBAL.SpawnPrefab("fire_projectile")    
projectile:AddComponent("weapon")    
projectile.Transform:SetPosition(act.doer.Transform:GetWorldPosition())    
projectile.components.projectile:Throw(act.doer, act.target)    
return true
end)
CASTFIRE.rmb = true
CASTFIRE.distance = 10
AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(GLOBAL.ACTIONS.CASTFIRE, "throw"))
AddPrefabPostInit("nappa", function(inst)    
	inst:DoTaskInTime(3, function()        
	local self = inst.components.playeractionpicker        
	self.rightclickoverride = function(inst, target, position)            
	local actions = {}            
	if target and target.replica.health and not (inst == target) then                
	table.insert(actions, GLOBAL.ACTIONS.CASTFIRE)            
	end            
	return 
	self:SortActionList(actions, target)        
	end   
	end)
end)

if GLOBAL.TheNet:GetIsServer() then

AddPrefabPostInit("vegeta", function(inst)
inst:AddComponent("sanityaura")
inst.components.sanityaura.aura = 0
end)

AddComponentPostInit("sanityaura", function(self)
local old = self.GetAura 
function self:GetAura(observer) 
if observer.prefab == "nappa" and self.inst.prefab == "vegeta" then 
return 1 
end
return old(self,observer) 
end
end)	

end

-- The character select screen lines
STRINGS.CHARACTER_TITLES.nappa = "General of the Saiyan Army . . . until Vegeta killed him."
STRINGS.CHARACTER_NAMES.nappa = "Nappa"
STRINGS.CHARACTER_DESCRIPTIONS.nappa = "*Shoots fireballs\n*Increased Hunger.\n*Has a real fear of Vegeta..."
STRINGS.CHARACTER_QUOTES.nappa = "\"Vegeta, what does the scouter say about his power level?\""

-- Custom speech strings
STRINGS.CHARACTERS.NAPPA = require "speech_nappa"

-- The character's name as appears in-game 
STRINGS.NAMES.NAPPA = "Nappa"

AddMinimapAtlas("images/map_icons/nappa.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("nappa", "MALE")

