local function DoMountSound(inst, mount, sound, ispredicted)
    if mount ~= nil and mount.sounds ~= nil then
        inst.SoundEmitter:PlaySound(mount.sounds[sound], nil, nil, ispredicted)
    end
end
return State{
    name = "attack",
    tags = { "attack", "notalking", "abouttoattack" },

    onenter = function(inst)
        local cooldown = 0
		 local buffaction = inst:GetBufferedAction()
        local target = buffaction ~= nil and buffaction.target or nil
        if inst.replica.combat ~= nil then
            inst.replica.combat:StartAttack()
            cooldown = inst.replica.combat:MinAttackPeriod() + .5 * FRAMES
        end
        inst.components.locomotor:Stop()
        local equip = inst.replica.inventory:GetEquippedItem(EQUIPSLOTS.HANDS)
        local rider = inst.replica.rider
        if rider ~= nil and rider:IsRiding() then
            if equip ~= nil and (equip:HasTag("rangedweapon") or equip:HasTag("projectile")) then
                inst.AnimState:PlayAnimation("player_atk_pre")
                inst.AnimState:PushAnimation("player_atk", false)
                if (equip.projectiledelay or 0) > 0 then
                    --V2C: Projectiles don't show in the initial delayed frames so that
                    --     when they do appear, they're already in front of the player.
                    --     Start the attack early to keep animation in sync.
                    inst.sg.statemem.projectiledelay = 8 * FRAMES - equip.projectiledelay
                    if inst.sg.statemem.projectiledelay > FRAMES then
                        inst.sg.statemem.projectilesound =
                            (equip:HasTag("icestaff") and "dontstarve/wilson/attack_icestaff") or
                            (equip:HasTag("firestaff") and "dontstarve/wilson/attack_firestaff") or
                            "dontstarve/wilson/attack_weapon"
                    elseif inst.sg.statemem.projectiledelay <= 0 then
                        inst.sg.statemem.projectiledelay = nil
                    end
                end
                if inst.sg.statemem.projectilesound == nil then
                    inst.SoundEmitter:PlaySound(
                        (equip:HasTag("icestaff") and "dontstarve/wilson/attack_icestaff") or
                        (equip:HasTag("firestaff") and "dontstarve/wilson/attack_firestaff") or
                        "dontstarve/wilson/attack_weapon",
                        nil, nil, true
                    )
                end
                if cooldown > 0 then
                    cooldown = math.max(cooldown, 13 * FRAMES)
                end
            else
                inst.AnimState:PlayAnimation("atk_pre")
                inst.AnimState:PushAnimation("atk", false)
                DoMountSound(inst, rider:GetMount(), "angry")
                if cooldown > 0 then
                    cooldown = math.max(cooldown, 16 * FRAMES)
                end
            end
        elseif equip ~= nil and equip:HasTag("whip") then
            inst.AnimState:PlayAnimation("whip_pre")
            inst.AnimState:PushAnimation("whip", false)
            inst.sg.statemem.iswhip = true
            inst.SoundEmitter:PlaySound("dontstarve/common/whip_pre", nil, nil, true)
            if cooldown > 0 then
                cooldown = math.max(cooldown, 17 * FRAMES)
            end
            
    
        elseif equip ~= nil and equip:HasTag("yuligun_full") and target~=nil then
			local pos = target:GetPosition()
			local my = inst:GetPosition()
			local a = pos.x - my.x
			local c = pos.z - my.z
			local ma = 2.5*a/math.sqrt(a*a+c*c)
			local mc = 2.5*c/math.sqrt(a*a+c*c)
			inst.AnimState:PlayAnimation("fishing_pst")
			inst:DoTaskInTime(0.1,
			function(inst)
			local sparksa = SpawnPrefab("sparks")
			sparksa.Transform:SetPosition(my.x+ma,0,my.z+mc)
			sparksa.Transform:SetScale(1.3,1.3,1.3)
			local gunfire = SpawnPrefab("gunfire")
			gunfire.Transform:SetPosition(my.x+ma,0,my.z+mc)
			gunfire.Transform:SetScale(1.3,1.3,1.3)
		if target:HasTag("chess")	 then 
			local sparksb = SpawnPrefab("sparks")
			sparksb.Transform:SetPosition(pos.x,pos.y,pos.z)
			sparksb.Transform:SetScale(1.3,1.3,1.3)
		end	
		if not target:HasTag("chess") and not target:HasTag("nightmare") then 
			local blood = SpawnPrefab("gunblood")
			blood.Transform:SetPosition(pos.x,pos.y,pos.z)
			blood.Transform:SetScale(0.4,0.4,0.4)
		end 
			
			inst.SoundEmitter:PlaySound("dontstarve/rain/thunder_close")
			--target.components.health:DoDelta(-100)
            inst.AnimState:PushAnimation("idle", false)
			end
			)
			
           -- inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon", nil, nil, true)
     
             if cooldown > 0 then
            cooldown = math.max(cooldown, 10 * FRAMES)                              
            end
			
		elseif equip ~= nil and equip:HasTag("yuligun_empty") and target~=nil  then
			inst.AnimState:PlayAnimation("atk_pre")
            inst.AnimState:PushAnimation("atk", false)
            inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon", nil, nil, true)
            if cooldown > 0 then
			 cooldown = math.max(cooldown, 13 * FRAMES)          			
			end
        elseif equip ~= nil and equip:HasTag("book") then
            inst.AnimState:PlayAnimation("attack_book")
            inst.sg.statemem.isbook = true
            inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_whoosh", nil, nil, true)
            if cooldown > 0 then
                cooldown = math.max(cooldown, 19 * FRAMES)
            end
        elseif equip ~= nil and equip:HasTag("chop_attack") and inst:HasTag("woodcutter") then
            inst.AnimState:PlayAnimation(inst.AnimState:IsCurrentAnimation("woodie_chop_loop") and inst.AnimState:GetCurrentAnimationTime() < 7.1 * FRAMES and "woodie_chop_atk_pre" or "woodie_chop_pre")
            inst.AnimState:PushAnimation("woodie_chop_loop", false)
            inst.sg.statemem.ischop = true
            cooldown = math.max(cooldown, 11 * FRAMES)
        elseif equip ~= nil and
            equip.replica.inventoryitem ~= nil and
            equip.replica.inventoryitem:IsWeapon() and
            not equip:HasTag("punch") then
            inst.AnimState:PlayAnimation("atk_pre")
            inst.AnimState:PushAnimation("atk", false)
            if (equip.projectiledelay or 0) > 0 then
                --V2C: Projectiles don't show in the initial delayed frames so that
                --     when they do appear, they're already in front of the player.
                --     Start the attack early to keep animation in sync.
                inst.sg.statemem.projectiledelay = 8 * FRAMES - equip.projectiledelay
                if inst.sg.statemem.projectiledelay > FRAMES then
                    inst.sg.statemem.projectilesound =
                        (equip:HasTag("icestaff") and "dontstarve/wilson/attack_icestaff") or
                        (equip:HasTag("firestaff") and "dontstarve/wilson/attack_firestaff") or
                        "dontstarve/wilson/attack_weapon"
                elseif inst.sg.statemem.projectiledelay <= 0 then
                    inst.sg.statemem.projectiledelay = nil
                end
            end
            if inst.sg.statemem.projectilesound == nil then
                inst.SoundEmitter:PlaySound(
                    (equip:HasTag("icestaff") and "dontstarve/wilson/attack_icestaff") or
                    (equip:HasTag("shadow") and "dontstarve/wilson/attack_nightsword") or
                    (equip:HasTag("firestaff") and "dontstarve/wilson/attack_firestaff") or
                    "dontstarve/wilson/attack_weapon",
                    nil, nil, true
                )
            end
            if cooldown > 0 then
                cooldown = math.max(cooldown, 13 * FRAMES)
            end
        elseif equip ~= nil and
            (equip:HasTag("light") or
            equip:HasTag("nopunch")) then
            inst.AnimState:PlayAnimation("atk_pre")
            inst.AnimState:PushAnimation("atk", false)
            inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon", nil, nil, true)
            if cooldown > 0 then
                cooldown = math.max(cooldown, 13 * FRAMES)
            end
        elseif inst:HasTag("beaver") then
            inst.sg.statemem.isbeaver = true
            inst.AnimState:PlayAnimation("atk_pre")
            inst.AnimState:PushAnimation("atk", false)
            inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_whoosh", nil, nil, true)
            if cooldown > 0 then
                cooldown = math.max(cooldown, 8 * FRAMES)
            end
        else
            inst.AnimState:PlayAnimation("punch")
            inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_whoosh", nil, nil, true)
            if cooldown > 0 then
                cooldown = math.max(cooldown, 24 * FRAMES)
            end
        end

        local buffaction = inst:GetBufferedAction()
        if buffaction ~= nil then
            inst:PerformPreviewBufferedAction()

            if buffaction.target ~= nil and buffaction.target:IsValid() then
                inst:FacePoint(buffaction.target:GetPosition())
                inst.sg.statemem.attacktarget = buffaction.target
            end
        end

        if cooldown > 0 then
            inst.sg:SetTimeout(cooldown)
        end
    end,

    onupdate = function(inst, dt)
        if (inst.sg.statemem.projectiledelay or 0) > 0 then
            inst.sg.statemem.projectiledelay = inst.sg.statemem.projectiledelay - dt
            if inst.sg.statemem.projectiledelay <= FRAMES then
                if inst.sg.statemem.projectilesound ~= nil then
                    inst.SoundEmitter:PlaySound(inst.sg.statemem.projectilesound, nil, nil, true)
                    inst.sg.statemem.projectilesound = nil
                end
                if inst.sg.statemem.projectiledelay <= 0 then
                    inst:ClearBufferedAction()
                    inst.sg:RemoveStateTag("abouttoattack")
                end
            end
        end
    end,

    timeline =
    {
        TimeEvent(6 * FRAMES, function(inst)
            if inst.sg.statemem.isbeaver then
                inst:ClearBufferedAction()
                inst.sg:RemoveStateTag("abouttoattack")
            elseif inst.sg.statemem.ischop then
                inst.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon", nil, nil, true)
            end
        end),
        TimeEvent(8 * FRAMES, function(inst)
            if not (inst.sg.statemem.isbeaver or
                    inst.sg.statemem.iswhip or
                    inst.sg.statemem.isbook) and
                inst.sg.statemem.projectiledelay == nil then
                inst:ClearBufferedAction()
                inst.sg:RemoveStateTag("abouttoattack")
            end
        end),
        TimeEvent(10 * FRAMES, function(inst)
            if inst.sg.statemem.iswhip or inst.sg.statemem.isbook then
                inst:ClearBufferedAction()
                inst.sg:RemoveStateTag("abouttoattack")
            end
        end),
    },

    ontimeout = function(inst)
        inst.sg:RemoveStateTag("attack")
        inst.sg:AddStateTag("idle")
    end,

    events =
    {
        EventHandler("animqueueover", function(inst)
            if inst.AnimState:AnimDone() then
                inst.sg:GoToState("idle")
            end
        end),
    },

    onexit = function(inst)
        if inst.sg:HasStateTag("abouttoattack") and inst.replica.combat ~= nil then
            inst.replica.combat:CancelAttack()
        end
    end,
}
