local assets =
{ 
    Asset("ANIM", "anim/yulihamlet.zip"),
    --Asset("ANIM", "anim/yulihamlet_swap.zip"), 

    Asset("ATLAS", "images/inventoryimages/yulihamlet.xml"),
    Asset("IMAGE", "images/inventoryimages/yulihamlet.tex"),
}

	local function OnEquip(inst, owner) 
		--owner.AnimState:OverrideSymbol("swap_hat", "yulihamlet", "swap_hat")
		owner.AnimState:OverrideSymbol("swap_hat", "yulihamlet", "swap_yulihamlet")
		
		owner.AnimState:Show("HAT")
		owner.AnimState:Show("HAT_HAIR")
		owner.AnimState:Hide("HAIR_NOHAT")
		owner.AnimState:Hide("HAIR")

		if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAT")
		end
	end

	local function OnUnequip(inst, owner) 

		owner.AnimState:Hide("HAT")
		owner.AnimState:Hide("HAT_HAIR")
		owner.AnimState:Show("HAIR_NOHAT")
		owner.AnimState:Show("HAIR")

		if owner:HasTag("player") then
	        owner.AnimState:Show("HEAD")
			owner.AnimState:Hide("HEAD_HAT")
		end
	end

local function fn()

    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
	
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()  --这个联机也必须加 
	
    MakeInventoryPhysics(inst)
	inst.entity:AddMiniMapEntity()
	inst.MiniMapEntity:SetIcon( "yulihamlet.tex" )

    inst:AddTag("hat")
	
	inst.AnimState:SetBank("yulihamlet")
    inst.AnimState:SetBuild("yulihamlet")
    inst.AnimState:PlayAnimation("anim")
	
	
	----------------------上面的东西 对主副机都有效
	
	inst.entity:SetPristine()   --这四句话 放到这里 也就是bank build 和tag之类的后面-。-
	if not TheWorld.ismastersim then
        return inst
    end
	
	----------------------下面的只对主机执行
	
    inst:AddComponent("inspectable")
	 
	inst:AddComponent("waterproofer")
	inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)


    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "yulihamlet"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/yulihamlet.xml"
	
	inst:AddComponent("armor")
    inst.components.armor:InitCondition(800, 0.8)
     
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	MakeHauntableLaunch(inst)  --这个放后面就好了
    return inst
end
STRINGS.NAMES.YULIHAMLET = "尤莉的头盔"
STRINGS.RECIPE_DESC.YULIHAMLET = "尤莉一直带着的头盔"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.YULIHAMLET = "呐，千酱~这个头盔戴着有什么用呢？"

return  Prefab("common/inventory/yulihamlet", fn, assets, prefabs)