require "prefabutil"
local assets=
{
	Asset("ANIM", "anim/tankcamp.zip"),
}

local function onopen(inst) 
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_open")	
	--inst.SoundEmitter:PlaySound("dontstarve/movement/foley/backpack")			
    inst.AnimState:PlayAnimation("open")
end 

local function onclose(inst) 
	inst.AnimState:PlayAnimation("closed")
	inst.SoundEmitter:PlaySound("dontstarve/wilson/chest_close")
	--inst.SoundEmitter:PlaySound("dontstarve/movement/foley/backpack")		
end 

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	inst.components.container:DropEverything()
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_metal")
	--inst.Light:Enable(false)
	inst:Remove()
end

local function onhit(inst, worker)
	inst.AnimState:PlayAnimation("closed")
	inst.components.container:DropEverything()
	inst.components.container:Close()
end

local function onbuilt(inst)
	inst.AnimState:PlayAnimation("place")
	inst.AnimState:PushAnimation("closed")	
end



local function getsanityaura(inst, observer)
   	local x,y,z = inst.Transform:GetWorldPosition()   
			local delta = 0
			local rad = 80
			local rad_sq = rad*rad
			for k,v in pairs(AllPlayers) do
				if v ~= inst and  not v:HasTag("playerghost") then   
					local distsq = inst:GetDistanceSqToInst(v)
					if distsq < rad_sq then
						local sz = rad * 0.2
						delta = delta + sz/(math.max(1, distsq))
					end
				end
			end
	return delta
end

local function fn(Sim)
	local inst = CreateEntity()

    inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
	inst.entity:AddMiniMapEntity()
	--inst.Transform:SetScale(0.6,0.6,0.6)
    MakeObstaclePhysics(inst,2.2)
	--MakeSnowCoveredPristine(inst)
	
	local minimap = inst.entity:AddMiniMapEntity()
	minimap:SetIcon( "tankcamp.tex" )

    if not TheWorld.ismastersim then
    return inst
    end
	
	inst:AddComponent("sanityaura")
    inst.components.sanityaura.aurafn = getsanityaura
    inst.entity:SetPristine()	

    inst.AnimState:SetBank("tankcamp")
    inst.AnimState:SetBuild("tankcamp")
    inst.AnimState:PlayAnimation("closed", true)
    
    inst:AddComponent("inspectable")

    inst:AddComponent("container")
    inst.components.container:WidgetSetup("tankcamp")    
    inst.components.container.onopenfn = onopen
    inst.components.container.onclosefn = onclose
    
    inst:AddComponent("lootdropper")
	    --MakeHauntableWork(inst)

	

    if yep then

    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(5)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)
end

    return inst
end

return Prefab( "common/tankcamp", fn, assets),
	MakePlacer("common/tankcamp_placer", "tankcamp", "tankcamp", "closed") 

