local assets = 
{
	Asset("ANIM", "anim/ranger_bullet.zip"),
	Asset("ATLAS", "images/inventoryimages/ranger_bullet.xml"),
}

local function fn()
	local inst = CreateEntity()
	
	inst.entity:AddTransform()
	--inst.Transform:SetScale(.3,.3,.3)
	
	inst.entity:AddAnimState()
	inst.AnimState:SetBank("ranger_bullet")
	inst.AnimState:SetBuild("ranger_bullet")
	inst.AnimState:PlayAnimation("idle")
	
	MakeInventoryPhysics(inst)
	
	inst.entity:AddNetwork()
	
	inst.entity:SetPristine()
	
	if not TheWorld.ismastersim then
		return inst
	end
	
	----用来填充弹药
	inst:AddComponent("tradable")
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/ranger_bullet.xml"
	inst.components.inventoryitem.imagename = "ranger_bullet"
	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = TUNING.STACK_SIZE_LARGEITEM
	
	inst:AddComponent("inspectable")
	inst.components.inspectable:SetDescription("Yuko超喜欢次的~~~")
	
	return inst
end

STRINGS.NAMES.RANGER_BULLET = "游骑兵子弹"
STRINGS.RECIPE_DESC.RANGER_BULLET = "大口径步枪子弹"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.RANGER_BULLET = "没有子弹的枪就像没有巧克力酱的面包~"
return Prefab("ranger_bullet", fn, assets)
