local assets=
{ 
    Asset("ANIM", "anim/ranger.zip"),
    Asset("ANIM", "anim/swap_ranger.zip"), 
    Asset("ATLAS", "images/inventoryimages/ranger.xml"),		
}

local function onattack(inst, owner, target)
			if inst.components.equippable.isequipped then
			--local owner = inst.components.inventoryitem.owner
				inst.components.finiteuses.current = 0
				if inst:HasTag("yuligun_full") then inst:RemoveTag("yuligun_full") end
				inst:AddTag("yuligun_empty")
				if inst.components.weapon then
					inst:RemoveComponent("weapon")
					inst:RemoveComponent("yuligun")
				end
			
			end 

end
local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_ranger", "swap_ranger")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal")
	if inst.components.equippable.isequipped then
			--local owner = inst.components.inventoryitem.owner
			if   inst.components.finiteuses.current ~=  1 then
				inst.components.finiteuses.current = 0
				if inst:HasTag("yuligun_full") then inst:RemoveTag("yuligun_full") end
				inst:AddTag("yuligun_empty")
				if inst.components.weapon then
					inst:RemoveComponent("weapon")
					inst:RemoveComponent("yuligun")
				end
			else
				if not inst.components.weapon then
					inst:AddComponent("weapon")
					inst:AddComponent("yuligun")
					inst.components.weapon:SetDamage(1)
					inst.components.weapon:SetRange(10, 12)
					inst.components.weapon:SetOnAttack(onattack)
					--inst.components.weapon:SetProjectile("fire_projectile")
					inst.components.yuligun:SetProjectile("fire_projectile")
				end
			end
		end
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end



---------------------------------------------------------------
local function OnGetItemFromPlayer(inst, giver, item)
    if item.prefab == inst.gunbullet then
		local current = inst.components.finiteuses.current
		if current == 0 then 
			--inst.components.finiteuses.current = inst.components.finiteuses.current + 30
			--inst:PushEvent("percentusedchange", {percent = inst.components.finiteuses:GetPercent()})
			inst.components.finiteuses:SetUses(current + 1)
			if inst:HasTag("yuligun_empty") then inst:RemoveTag("yuligun_empty") end
				inst:AddTag("yuligun_full")
			inst:AddComponent("weapon")
			inst:AddComponent("yuligun")
			inst.components.weapon:SetDamage(1)
			inst.components.weapon:SetRange(10, 12)
			inst.components.weapon:SetOnAttack(onattack)
			--inst.components.weapon:SetProjectile("fire_projectile")
			inst.components.yuligun:SetProjectile("fire_projectile")
		end
    end
end

local function OnRefuseItem(inst, giver, item)
	if item.prefab == inst.gunbullet then
		giver.components.talker:Say("填弹已经完毕!")
	else
		giver.components.talker:Say("不是配套的子弹!")
	end

end

local function AcceptTest(inst, item)
    return inst.components.finiteuses.current == 0 and item.prefab == inst.gunbullet
end
---------------------------------------------------------------
local function fn()

	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter() 
	inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    
    anim:SetBank("ranger")
    anim:SetBuild("ranger")
    anim:PlayAnimation("idle")
	inst:AddTag("yuligun_full")


	inst.zg_num_ini = 400
	inst.zg_detail_gunhp = inst.zg_num_ini
	

	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end
	
	inst.gunbullet = "ranger_bullet"
	
	----被填充弹药
	inst:AddComponent("trader")
    inst.components.trader:SetAcceptTest(AcceptTest)
    inst.components.trader.onaccept = OnGetItemFromPlayer
    inst.components.trader.onrefuse = OnRefuseItem
    
	inst:AddComponent("finiteuses")
	inst.components.finiteuses:SetMaxUses(1)
    inst.components.finiteuses:SetUses(1)	
	
    inst:AddComponent("weapon")
	
	inst.components.weapon.onattack = onattack
    inst.components.weapon:SetDamage(1)					
    inst.components.weapon:SetRange(10, 12)
	--inst.components.weapon:SetProjectile("fire_projectile")
	inst:AddComponent("yuligun")
	inst.components.yuligun:SetProjectile("fire_projectile")
	inst:AddComponent("lootdropper")----结算
	
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/ranger.xml"
	inst.components.inventoryitem.imagename = "ranger"
	inst:AddComponent("inspectable")
	inst.components.inspectable:SetDescription("尤莉的步枪斯国一~")
 
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

	----保存载入

    return inst
end

STRINGS.NAMES.RANGER = "游骑兵"
STRINGS.RECIPE_DESC.RANGER = "一把拉栓式步枪"

--STRINGS.CHARACTERS.GENERIC.DESCRIBE.RANGER = "尤莉的步枪斯国一~"

return  Prefab("common/inventory/ranger", fn, assets)