
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/qianhu.zip" ),
        Asset( "ANIM", "anim/ghost_qianhu_build.zip" ),
}
local prefabs = {
"qianhuhamlet",
}

-- Custom starting items
local start_inv = {
"qianhuhamlet",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end

local function checkbook(item) ----------һƷǷִС鱾
	if item and string.find(item.prefab,'book')  then 
		return true
	end
	return false 
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "qianhu.tex" )
	inst:AddTag("tankcamp_builder")
	inst:AddTag("junliang_builder")
	inst:AddTag("qianhuhamlet_builder")
	inst:AddTag("qianhu")
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "wendy"
	inst.components.freezable.resistance = 20
	inst.components.temperature.mintemp = 0
	inst.components.temperature.inherentinsulation = TUNING.INSULATION_MED
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	--inst.sg.sg.states.eat = inst.sg.sg.states.quickeat --Զٶȿ룬
	-- Stats	
	inst.components.health:SetMaxHealth(100)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(200)
    inst.Transform:SetScale(1.1, 1.1, 1.1)
	inst.components.builder.science_bonus = 1

	inst.components.sanity.rate_modifier = 1    
	local function sanityfn(inst)
			local books = inst.components.inventory:FindItems(checkbook) ---------ⱳ鱾
			local x,y,z = inst.Transform:GetWorldPosition()   
			local delta = 0
			local rad = 20
			local rad_sq = rad*rad
			for k,v in pairs(AllPlayers) do
				if v ~= inst and v:HasTag("yuli")  then    ------------֮βƵİ
					local distsq = inst:GetDistanceSqToInst(v)
					if distsq < rad_sq then
						local sz = rad * 0.2
						delta = delta + sz/math.max(1, distsq)
					end
				end
			end
			delta = delta + #books*0.1     ----------------ǧϲռ鱾
			--print(delta,#books)           ----------------鿴
			return delta
		end
inst.components.sanity.custom_rate_fn = sanityfn
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1.0 * TUNING.WILSON_HUNGER_RATE
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("qianhu", prefabs, assets, common_postinit, master_postinit, start_inv)
