local assets = 
{
	Asset( "ANIM", "anim/junliang.zip" ),
	Asset( "ATLAS", "images/inventoryimages/junliang.xml" ),
}

local function fn0()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("junliang")
    inst.AnimState:SetBuild("junliang")
    --inst.AnimState:PlayAnimation("idle")

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	--inst.components.inventoryitem.atlasname = "images/junliang.xml"
	--inst.components.inventoryitem.imagename = "junliang"
	
	inst:AddComponent("edible")
	inst.components.edible.healthvalue = 30
    inst.components.edible.hungervalue = 35
    inst.components.edible.sanityvalue = 30
	--inst.components.edible.foodtype = FOODTYPE.MEAT
	
	inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_MEDITEM
	
	inst:AddComponent("perishable")
    inst.components.perishable:SetPerishTime( 356 * TUNING.TOTAL_DAY_TIME)
    inst.components.perishable:StartPerishing()
    inst.components.perishable.onperishreplacement = "spoiled_food"

    return inst
end

local function fn()

	local inst = fn0()

	inst.AnimState:PlayAnimation("idle")
	inst.Transform:SetScale(0.5,0.5,0.5)
	if not TheWorld.ismastersim then
        return inst
    end
	
	inst.components.inventoryitem.atlasname = "images/inventoryimages/junliang.xml"
	inst.components.inventoryitem.imagename = "junliang"
	
	inst.components.edible.foodtype = FOODTYPE.VEGGIE

	return inst
end
STRINGS.NAMES.JUNLIANG = "袋装军粮"
STRINGS.RECIPE_DESC.JUNLIANG = "居家旅行必备食品!"

STRINGS.CHARACTERS.GENERIC.DESCRIBE.JUNLIANG = "尤莉最喜欢次了~"
return Prefab("junliang", fn, assets)



