PrefabFiles = 
{
	"zg_canswim_pond",
}

Assets =
{
	Asset("ATLAS", "images/zg_canswim_pond.xml"),
}

--配方
local zg_canswim_pond = AddRecipe("zg_canswim_pond",
{GLOBAL.Ingredient("ice", 40), GLOBAL.Ingredient("cutreeds", 40), GLOBAL.Ingredient("wall_wood_item", 40)}, 
GLOBAL.RECIPETABS.SURVIVAL, GLOBAL.TECH.NONE,
"zg_canswim_pond_placer", nil, nil, nil, nil,
"images/zg_canswim_pond.xml", "zg_canswim_pond.tex")
GLOBAL.STRINGS.NAMES.ZG_CANSWIM_POND = "Swimming Pond"
GLOBAL.STRINGS.RECIPE_DESC.ZG_CANSWIM_POND = "We can swim with my friends"
GLOBAL.STRINGS.CHARACTERS.GENERIC.DESCRIBE.ZG_CANSWIM_POND = "A swimming pond"

--池塘
local function pondfn(inst)

	--增加标签
	inst:AddTag("canswim_pond")

	--修改物体系统
    local phys = inst.entity:AddPhysics()
    phys:SetMass(0) 
    phys:SetCapsule(0, 0)
    phys:SetCollisionGroup(GLOBAL.COLLISION.OBSTACLES)
    phys:ClearCollisionMask()
	
	--池塘半径大2倍
	inst.Transform:SetScale(1.6,1.6,1.6)

	if GLOBAL.TheWorld.ismastersim then
		
		--池塘边界检测
		inst:DoPeriodicTask(1/30, function(inst)	
			local x, y, z = inst.Transform:GetWorldPosition()
			local ents = GLOBAL.TheSim:FindEntities(x,y,z,5,{"player"},{"playerghost"})
			for k,v in ipairs(ents) do
				if v and v.components.health and not v.components.health:IsDead() then
					local dist = v:GetPosition():Dist(inst:GetPosition())
					if dist <= 5 and dist >= 4.8 then
						--在边界跳一下
						if v.sg and not v.sg:HasStateTag("nopredict") then
							v.sg:GoToState("jumpout")
						end
					end
				end
			end
		end)
		
		--建造时生成墙壁
		inst:ListenForEvent("onbuilt", function(inst, data)
			local x,y,z = inst.Transform:GetWorldPosition()
			for k = -2, 2 do
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x+k,0,z+6)
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x+k,0,z-6)
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x+6,0,z+k)
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x-6,0,z-k)
			end
			for k = 3, 5 do
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x+k,0,z+8-k)
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x+k,0,z+k-8)
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x-k,0,z+8-k)
				GLOBAL.SpawnPrefab("wall_wood").Transform:SetPosition(x-k,0,z+k-8)
			end
		end)
		
	end
end
local pondtable = 
{
	--"pond", "pond_mos", "pond_cave",
	"zg_canswim_pond",
}
for k,v in pairs(pondtable) do
	AddPrefabPostInit(v, pondfn)
end

--玩家
AddPlayerPostInit(function(inst)
	if GLOBAL.TheWorld.ismastersim then
	
		--可以抓鱼
		inst.cancatchfish_pond = 0
	
		inst:DoPeriodicTask(1, function()
			if inst.components.health and not inst.components.health:IsDead() and not inst:HasTag("playerghost") then
				local pond = GLOBAL.FindEntity(inst, 4.8, function(guy)
					return guy and guy:HasTag("canswim_pond") and guy:HasTag("watersource")
				end)
				if pond then
					--在水池里速度减慢
					inst:AddTag("groggy")
					if inst.components.locomotor then
						inst.components.locomotor:SetExternalSpeedMultiplier(inst, "swim_pond_mod", 0.7)
					end
					--回san
					if inst.components.sanity then
						inst.components.sanity:DoDelta(1, true)
					end
					--扣饥饿,回血,前提是不饿得掉血
					if inst.components.hunger then
						inst.components.hunger:DoDelta(-1, true, true)
						if not inst.components.hunger:IsStarving() then
							inst.components.health:DoDelta(1, true, nil, true)	
						end
					end	
					--抓鱼计时
					inst.cancatchfish_pond = inst.cancatchfish_pond + 1
					if inst.cancatchfish_pond >= 60 then
						--获得一条鱼
						if inst.components.inventory then
							inst.components.inventory:GiveItem( GLOBAL.SpawnPrefab( pond.planttype == "pond_algae" and "eel" or "fish") )
						end
						--说话
						if inst.components.talker then
							inst.components.talker:Say("Wow! I get a fish!")
						end						
						--计时重置
						inst.cancatchfish_pond = 0
					end
				else
					--离开池塘则恢复速度
					inst:RemoveTag("groggy")
					if inst.components.locomotor then
						inst.components.locomotor:SetExternalSpeedMultiplier(inst, "swim_pond_mod", 1)
					end
					--一旦离开池塘,抓鱼停止
					inst.cancatchfish_pond = 0
				end
			end
		end)
	end
end)






