
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),      

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/physalis.zip" ),
				Asset( "ANIM", "anim/ghost_physalis_build.zip" ),
}
local prefabs = { "sparks" }
local function common_postinit(inst)
    inst.avatar_tex   = "avatar_physalis.tex"
    inst.avatar_atlas = "images/avatars/avatar_physalis.xml"
     
    inst.avatar_ghost_tex   = "avatar_ghost_physalis.tex"
    inst.avatar_ghost_atlas = "images/avatars/avatar_ghost_physalis.xml"

    inst.self_inspect_tex   = "self_inspect_physalis.tex"
    inst.self_inspect_atlas = "images/avatars/self_inspect_physalis.xml"
end
local start_inv = {  }

local function master_postinit(inst)
	inst.soundsname = "physalis"

    inst.entity:AddMiniMapEntity()
    inst.MiniMapEntity:SetIcon("physalismini.tex")
	

local function dorainsparks(inst, dt)
    if inst.components.moisture ~= nil and inst.components.moisture:GetMoisture() > 0 then
        local t = GetTime()

        -- Raining, no moisture-giving equipment on head, and moisture is increasing. Pro-rate damage based on waterproofness.
        if inst.components.inventory:GetEquippedMoistureRate(EQUIPSLOTS.HEAD) <= 0 and inst.components.moisture:GetRate() > 0 then
            local waterproofmult =
                (   inst.components.sheltered ~= nil and
                    inst.components.sheltered.sheltered and
                    inst.components.sheltered.waterproofness or 0
                ) +
                (   inst.components.inventory ~= nil and
                    inst.components.inventory:GetWaterproofness() or 0
                )
            if waterproofmult < 1 and t > inst.spark_time + inst.spark_time_offset + waterproofmult * 7 then
                inst.components.health:DoDelta(TUNING.WX78_MAX_MOISTURE_DAMAGE * -3, false, "rain")
                inst.spark_time_offset = 3 + math.random() * 2
                inst.spark_time = t
                local x, y, z = inst.Transform:GetWorldPosition()
                y = y + 1 + math.random() * 1.5
                SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
            end
        elseif t > inst.spark_time + inst.spark_time_offset then -- We have moisture-giving equipment on our head or it is not raining and we are just passively wet (but drying off). Do full damage.
            inst.components.health:DoDelta(
                inst.components.moisture:GetRate() >= 0 and
                TUNING.WX78_MAX_MOISTURE_DAMAGE * -3 or
                TUNING.WX78_MOISTURE_DRYING_DAMAGE * -3,
                false, "water")
            inst.spark_time_offset = 3 + math.random() * 2
            inst.spark_time = t
            local x, y, z = inst.Transform:GetWorldPosition()
            y = y + .25 + math.random() * 2
            SpawnPrefab("sparks").Transform:SetPosition(x, y, z)
        end
    end
end

local function onisraining(inst, israining)
    if israining then
        if inst.spark_task == nil then
            inst.spark_task = inst:DoPeriodicTask(.1, dorainsparks, nil, .1)
        end
    elseif inst.spark_task ~= nil then
        inst.spark_task:Cancel()
        inst.spark_task = nil
    end
end

local function onbecamerobot(inst)
    if not inst.watchingrain then
        inst.watchingrain = true
        inst:WatchWorldState("israining", onisraining)
        onisraining(inst, TheWorld.state.israining)
    end


end
    inst.level = 0
    inst.charged_task = nil
    inst.charge_time = 0
    inst.spark_task = nil
    inst.spark_time = 0
    inst.spark_time_offset = 3
    inst.watchingrain = false
	inst.components.sanity:SetMax(TUNING.WILSON_SANITY * 0.8)
	inst.components.hunger:SetMax(TUNING.WILSON_HUNGER * 0.9)
		inst.components.health:SetAbsorptionAmount(0.30)
			inst.components.combat.damagemultiplier = 0.80
				inst.components.temperature.inherentinsulation = 20 -- 0.75x wilson's

    inst.Light:Enable(false)
	inst.Light:SetRadius(2)
    inst.Light:SetFalloff(0.75)
    inst.Light:SetIntensity(.9)
    inst.Light:SetColour(235/255,121/255,12/255)
	

			inst.spark_time = 3
				inst:DoPeriodicTask(1/10, function() dorainsparks(inst, 1/10) end)
	--inst.OnSave = onsave
	--inst.OnLoad = onload
	--inst.OnPreLoad = onpreload


end
	

STRINGS.CHARACTER_TITLES.physalis = "The Protozoa"
STRINGS.CHARACTER_NAMES.physalis = "Physalis Hemoglobin"
STRINGS.CHARACTER_DESCRIPTIONS.physalis ="*Is 95 percent water\n*Doesn't mind spoiled food\n*Can take but not deal a beating"
STRINGS.CHARACTER_QUOTES.physalis = "\"I knew TV waaas maaade to just kill people's brain cells!\""
STRINGS.CHARACTERS.PHYSALIS = require "speech_physalis"

return MakePlayerCharacter("physalis", prefabs, assets, common_postinit, master_postinit, start_inv)