local assets=
{
     Asset("ANIM", "anim/santa_vest.zip"),
     Asset("ATLAS", "images/inventoryimages/santa_vest.xml"),
}

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_body", "santa_vest", "swap_body")
    inst.components.fueled:StartConsuming()
end

local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
    inst.components.fueled:StopConsuming()
end

local function fn()
	local inst = CreateEntity()
    inst.entity:AddTransform()
	inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("armor_trunkvest_summer")
    inst.AnimState:SetBuild("santa_vest")
    inst.AnimState:PlayAnimation("anim")

    inst.foleysound = "dontstarve/movement/foley/trunksuit"

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "santa_vest"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/santa_vest.xml"
    inst.components.inventoryitem.foleysound = "dontstarve/movement/foley/trunksuit"

    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BODY

    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )

    inst:AddComponent("dapperness")
    if TinyDapperness then inst.components.dapperness.dapperness = TUNING.DAPPERNESS_TINY
end
    if SmallDapperness then inst.components.dapperness.dapperness = TUNING.DAPPERNESS_SMALL
end
    if MediumDapperness then inst.components.dapperness.dapperness = TUNING.DAPPERNESS_MED
end
    if LargeDapperness then inst.components.dapperness.dapperness = TUNING.DAPPERNESS_LARGE
end
    if HugeDapperness then inst.components.dapperness.dapperness = TUNING.DAPPERNESS_HUGE
end

    inst:AddComponent("insulator")
    if TinyInsulation then inst.components.insulator.insulation = TUNING.INSULATION_TINY
end
    if SmallInsulation then inst.components.insulator.insulation = TUNING.INSULATION_SMALL
end
    if MediumInsulation then inst.components.insulator.insulation = TUNING.INSULATION_MED
end
    if LargeInsulation then inst.components.insulator.insulation = TUNING.INSULATION_LARGE
end

    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.USAGE
    if Ten then inst.components.fueled:InitializeFuelLevel(TUNING.SWEATERVEST_PERISHTIME)
end 
    if Fifteen then inst.components.fueled:InitializeFuelLevel(TUNING.SWEATERVEST_PERISHTIME)
end 
    if Twenty then inst.components.fueled:InitializeFuelLevel(TUNING.SANTA_VEST_PERISHTIME)
end
    if Twentyfive then inst.components.fueled:InitializeFuelLevel(TUNING.WALRUSHAT_PERISHTIME)
end
    inst.components.fueled:SetDepletedFn(inst.Remove)

    MakeHauntableLaunch(inst)
    
    return inst
end

return Prefab( "common/inventory/santa_vest", fn, assets) 
