local assets=
{
	Asset("ANIM", "anim/candycane.zip"),
	Asset("ANIM", "anim/swap_candycane.zip"),
    Asset("ATLAS", "images/inventoryimages/candycane.xml")
}

local function onfinished(inst)
    inst:Remove()
end

local function onequip(inst, owner) 
    owner.AnimState:OverrideSymbol("swap_object", "swap_candycane", "swap_cane")
    owner.AnimState:Show("ARM_carry") 
    owner.AnimState:Hide("ARM_normal") 
end

local function onunequip(inst, owner) 
    owner.AnimState:Hide("ARM_carry") 
    owner.AnimState:Show("ARM_normal") 
end


local function fn()
    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
    inst.entity:AddNetwork()        

    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("cane")
    inst.AnimState:SetBuild("candycane")
    inst.AnimState:PlayAnimation("idle")
    

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()    

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(CaneDamage)
    
    inst:AddComponent("inspectable")
    
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.atlasname = "images/inventoryimages/candycane.xml"   

    inst:AddComponent("equippable")
    
    inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
    inst.components.equippable.walkspeedmult = Speed

    MakeHauntableLaunch(inst)    

    return inst
end

return Prefab( "common/inventory/candycane", fn, assets) 

