require("stategraphs/commonstates")

local events=
{    
    EventHandler("doattack", function(inst) 
		inst.sg:GoToState("attack")  
    end),
}

local states=
{   
    State{
        name = "idle",
        tags = {"idle", "canrotate"},
        onenter = function(inst)
            inst.sg:SetTimeout(1)
        end, 
		
		ontimeout = function(inst)
			inst.sg:GoToState("idle")
		end
    },

    State
    {
        name = "attack",
        tags = {"attack", "canrotate"},
        onenter = function(inst)
            inst.sg:SetTimeout(3*FRAMES)
        end,
        timeline=
        {
            TimeEvent(1*FRAMES, function(inst) 
                inst.components.combat:StartAttack()
                inst.components.combat:DoAttack()
            end),
        },

        ontimeout = function(inst)
			inst.sg:GoToState("idle")
		end
    },
}

return StateGraph("suofeiya_yezi_stone", states, events, "idle")
