

local brain = require "brains/suofeiya_yezi_brain"

local function retargetfn(inst)
    local playertargets = {}
	if inst.master and inst.master.components.combat.target ~= nil then
		playertargets[inst.master.components.combat.target] = true
	end

    local invader = FindEntity(inst, 20,
        function(guy)
            return inst.components.combat:CanTarget(guy)
                and (playertargets[guy] or
                    (guy.components.combat.target ~= nil and guy.components.combat.target:HasTag("player")))
        end,
        { "_combat" }, --see entityreplica.lua
        { "INLIMBO", "player"}
    )
	
	if invader then
		inst:GetWeapon(inst)
	end
	
	return invader
end

local function shouldKeepTarget(inst, target)
    return target ~= nil
        and target:IsValid()
        and target.components.health ~= nil
        and not target.components.health:IsDead()
        and inst:IsNear(target, 20)
end

--local function MakeStone(name, num)
	local function fn()
		local inst = CreateEntity()

		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddNetwork()
		
		MakeInventoryPhysics(inst)
		RemovePhysicsColliders(inst)
		
		inst.AnimState:SetBank("d_mengjiang")
		inst.AnimState:SetBuild("d_mengjiang")
		
		inst.AnimState:PlayAnimation("idle")

		inst:AddTag("FX")
		inst:AddTag("NOCLICK")
		inst:AddTag("suofeiya_part")

		inst.entity:SetPristine()

		if not TheWorld.ismastersim then
			return inst
		end

		inst.persists = false
		
		inst:AddComponent("inventory")
		
		inst.GetWeapon = function(inst)
			if inst.components.inventory ~= nil and not inst.components.inventory:GetEquippedItem(EQUIPSLOTS.HANDS) then
				local meleeweapon = CreateEntity()
				meleeweapon.entity:AddTransform()
				meleeweapon:AddComponent("weapon")
				meleeweapon.components.weapon:SetDamage(40)
				meleeweapon.components.weapon:SetRange(8 * 1.3, 10 * 1.3)
				meleeweapon.components.weapon:SetProjectile("suofeiya_projectile")
				meleeweapon:AddComponent("inventoryitem")
				meleeweapon.persists = false
				meleeweapon.components.inventoryitem:SetOnDroppedFn(inst.Remove)
				meleeweapon:AddComponent("equippable")
				inst.components.inventory:Equip(meleeweapon)
			end
		end
		
		inst:AddComponent("combat")
		--inst.components.combat:SetRange(8 * 1.3, 10 * 1.3)
		inst.components.combat:SetDefaultDamage(40)
		inst.components.combat:SetAttackPeriod(5)
		inst.components.combat:SetRetargetFunction(1, retargetfn)
		inst.components.combat:SetKeepTargetFunction(shouldKeepTarget)
		
		inst:ListenForEvent("onhitother", function(inst, data)
			local target = data.target
			if target and target.components.combat then
				target.components.combat:SetTarget(inst.master)
			end
		end)
		
		inst:SetBrain(brain)
		inst:SetStateGraph("SGsuofeiya_yezi_stone")
		
		inst:DoTaskInTime(10, function()
			if inst then
				inst:Remove()
			end
		end)

		return inst
	end
	return Prefab("suofeiya_yezi", fn)
--end

--[[
local stones = {}
for k = 0, 4 do
    table.insert( stones, MakeStone("patchouli_stone"..k, k) )
end
return unpack(stones)]]
	