
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/suofeiya.zip" ),
        Asset( "ANIM", "anim/ghost_suofeiya_build.zip" ),
}
local prefabs = {}

-- Custom starting items
local start_inv = {
	"mengjiang",
	"ciyuan",
	"huanxiang",
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Set speed when loading or reviving from ghost (optional)
	inst.components.locomotor.walkspeed = 4
	inst.components.locomotor.runspeed = 6
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end


-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst) 
	-- Minimap icon
	inst.MiniMapEntity:SetIcon( "suofeiya.tex" )
	
	--技能
	inst:AddTag("suofeiya_skiller")
	
	inst:AddComponent("zg_keyhandler_suofeiya")
	inst.components.zg_keyhandler_suofeiya:AddActionListener("suofeiya", KEY_X, "x_skill")
	inst.components.zg_keyhandler_suofeiya:AddActionListener("suofeiya", KEY_C, "c_skill")
	inst.components.zg_keyhandler_suofeiya:AddActionListener("suofeiya", KEY_V, "v_skill")
	inst.components.zg_keyhandler_suofeiya:AddActionListener("suofeiya", KEY_R, "r_skill")
	inst.components.zg_keyhandler_suofeiya:AddActionListener("suofeiya", KEY_L, "l_skill")
	inst.components.zg_keyhandler_suofeiya:AddActionListener("suofeiya", KEY_T, "t_skill")
	
	inst:AddComponent("timer")
	inst:ListenForEvent("timerdone", function(inst, data)
	
		--技能冷却好时
		if data.name == "x_skill" then	
			inst.x_skill = true
		elseif data.name == "c_skill" then
			inst.c_skill = true
		elseif data.name == "v_skill" then
			inst.v_skill = true
		elseif data.name == "r_skill" then
			inst.r_skill = true
		elseif data.name == "l_skill" then
			inst.l_skill = true
		elseif data.name == "t_skill" then
			inst.t_skill = true
			
		--被动
		elseif data.name == "wudi" then
			inst.wudi = true
		end
	end)
	
	
	inst.x_skill = true
	inst.c_skill = true
	inst.v_skill = true
	inst.r_skill = true
	inst.l_skill = true
	inst.t_skill = true		
	
	--inst.z_skill_cd = 20
	inst.x_skill_cd = 60
	inst.c_skill_cd = 60
	inst.v_skill_cd = 600
	inst.r_skill_cd = 60
	inst.l_skill_cd = 120
	inst.t_skill_cd = 150
	
	inst.wudi_cd = 120
	
	--if not (inst.z_skill or inst.components.timer:TimerExists("z_skill")) then
	--	inst.components.timer:StartTimer("z_skill", inst.z_skill_cd)
	--end
	if not (inst.x_skill or inst.components.timer:TimerExists("x_skill")) then
		inst.components.timer:StartTimer("x_skill", inst.x_skill_cd)
	end
	if not (inst.c_skill or inst.components.timer:TimerExists("c_skill")) then
		inst.components.timer:StartTimer("c_skill", inst.c_skill_cd)
	end
	if not (inst.v_skill or inst.components.timer:TimerExists("v_skill")) then
		inst.components.timer:StartTimer("v_skill", inst.v_skill_cd)
	end
	if not (inst.r_skill or inst.components.timer:TimerExists("r_skill")) then
		inst.components.timer:StartTimer("r_skill", inst.r_skill_cd)
	end
	if not (inst.l_skill or inst.components.timer:TimerExists("l_skill")) then
		inst.components.timer:StartTimer("l_skill", inst.l_skill_cd)
	end
	if not (inst.t_skill or inst.components.timer:TimerExists("t_skill")) then
		inst.components.timer:StartTimer("t_skill", inst.t_skill_cd)
	end
	
	--被动
	if not (inst.wudi or inst.components.timer:TimerExists("wudi")) then
		inst.components.timer:StartTimer("wudi", inst.wudi_cd)
	end
	
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "willow"
	
	-- Uncomment if "wathgrithr"(Wigfrid) or "webber" voice is used
    --inst.talker_path_override = "dontstarve_DLC001/characters/"
	
	-- Stats	
	inst.components.health:SetMaxHealth(200)
	inst.components.hunger:SetMax(100)
	inst.components.sanity:SetMax(150)
	
	-- Damage multiplier (optional)
    inst.components.combat.damagemultiplier = 1
	
	-- Hunger rate (optional)
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE
	
	--穿上特殊道具减伤
	--[[
	local old_attacked = inst.components.combat.GetAttacked
	function inst.components.combat:GetAttacked(attacker, damage, weapon, stimuli)
		local inv = inst.components.inventory
		if inv then
			local item1 = inv:GetEquippedItem(EQUIPSLOTS.BODY)
			if item1 and item1.prefab == "ciyuan" then
				damage = damage - 100
			end
			
			local item2= inv:GetEquippedItem(EQUIPSLOTS.HEAD)
			if item2 and item2.prefab == "mengjiang" then
				damage = damage - 100
			end
		end
		if damage < 0 then
			damage = 0
		end	
		
		return old_attacked(self, attacker, damage, weapon, stimuli)
	end]]
	
	----不怕冷不怕热
	inst.components.temperature.maxtemp = 35
	inst.components.temperature.mintemp = 35
	
	--inst:DoTaskInTime(.5, function()
		--if inst.userid == TUNING.SUOFEIYA_OKID then
		if true then
		
			--print("id_isok")
			
			----被动1，呆萌
			inst.summon_yezi = function(inst)
				local period = 1/30
				local r = 1.5
				for k = 0, 4 do
					if inst["fx"..k] == nil then
						inst["fx"..k] = SpawnPrefab("suofeiya_yezi")
						inst["fx"..k].persists = false
						inst["fx"..k].master = inst
						inst["fx"..k].n_per_sce = .5
						inst["fx"..k].start_angle = 360/5 * k
						inst["fx"..k]:DoPeriodicTask(period, function()
							local x,y,z = inst.Transform:GetWorldPosition()
							inst["fx"..k].start_angle = inst["fx"..k].start_angle + inst["fx"..k].n_per_sce * 360 * period
							while inst["fx"..k].start_angle > 360 do
								inst["fx"..k].start_angle = inst["fx"..k].start_angle - 360
							end
							inst["fx"..k].Transform:SetPosition( x + r * math.cos(inst["fx"..k].start_angle * DEGREES), 0, z - r * math.sin(inst["fx"..k].start_angle * DEGREES) )
						end)
					end
				end
			end
			
			--
			inst:DoPeriodicTask(1, function()
			
				----队友buff
				local x,y,z = inst.Transform:GetWorldPosition()
				local ents = TheSim:FindEntities(x,y,z,30)
				for k,v in pairs(ents) do
					if v and v.components.health and not v.components.health:IsDead() and v.components.combat and v ~= inst then
						if v:HasTag("player") and not v:HasTag("playerghost") then
							--if v.components.health then
							v.components.health:DoDelta(2)
							--end
						end
					end
				end
			
				--[[
				if inst.components.health and not inst.components.health:IsDead() and not inst:HasTag("playerghost") then
					inst.components.health:DoDelta(50/30, true)
					inst.components.sanity:DoDelta(50/30, true)
					inst.components.hunger:DoDelta(50/30, true)
				end]]
				
				
				--被动2 叶子
				local inv = inst.components.inventory
				if inv then
				
					--食物不腐烂
					for k,v in pairs(inv.itemslots) do
						if v and v.components.perishable then
							v.components.perishable:SetPercent(1)
						end
					end
				
					local hat= inv:GetEquippedItem(EQUIPSLOTS.HEAD)
					if hat and hat.prefab == "mengjiang" then
						if inst.suofeiya_hatlight == nil then
							inst.suofeiya_hatlight = SpawnPrefab("suofeiya_minerhatlight")
							inst.suofeiya_hatlight.entity:SetParent(inst.entity)
							inst.suofeiya_hatlight.Transform:SetPosition(0,0,0)
						end
						--头上叶子的吸收
						if inst.components.health and not inst.components.health:IsDead() and not inst:HasTag("playerghost") then
							inst.components.health:DoDelta(50/20, true)
							inst.components.sanity:DoDelta(50/20, true)
							inst.components.hunger:DoDelta(50/20, true)
						end
						
					else
						if inst.suofeiya_hatlight ~= nil then
							inst.suofeiya_hatlight:Remove()
							inst.suofeiya_hatlight = nil
						end
					end
				end
			end)
			
			inst.summon_fenshen = function (inst)
				local x,y,z = inst.Transform:GetWorldPosition()
				
				local girl1 = SpawnPrefab("suofeiya_fenshen")
				girl1.Transform:SetPosition(x,y,z)
				girl1.components.follower:SetLeader(inst)
				girl1.master = inst
				
				local girl2 = SpawnPrefab("suofeiya_fenshen")
				girl2.Transform:SetPosition(x,y,z)
				girl2.components.follower:SetLeader(inst)
				girl2.master = inst
				
				local girl3 = SpawnPrefab("suofeiya_fenshen")
				girl3.Transform:SetPosition(x,y,z)
				girl3.components.follower:SetLeader(inst)
				girl3.master = inst
				
				local girl4 = SpawnPrefab("suofeiya_fenshen")
				girl4.Transform:SetPosition(x,y,z)
				girl4.components.follower:SetLeader(inst)
				girl4.master = inst
				
				local girl5 = SpawnPrefab("suofeiya_fenshen")
				girl5.Transform:SetPosition(x,y,z)
				girl5.components.follower:SetLeader(inst)
				girl5.master = inst
			end
			
		end
	--end)
	
	----被打或攻击时才出现叶子和分身
	local function summon(inst, data)
		local x,y,z = inst.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x,y,z,30, {"suofeiya_part"})
		local num_yezi = 0
		local num_fenshen = 0
		for k, v in pairs(ents) do
			if v and v.master == inst then
				if v.prefab == "suofeiya_yezi" then
					num_yezi = num_yezi + 1
				elseif v.prefab == "suofeiya_fenshen" then
					num_fenshen = num_fenshen + 1
				end
			end
		end
		if num_yezi < 5 then
			inst.summon_yezi(inst)
		end
		if num_fenshen < 5 then
			inst.summon_fenshen(inst)
		end
		
	end
	inst:ListenForEvent("onattackother", summon)
	inst:ListenForEvent("attacked", function(inst, data)
		summon(inst, data)
		if inst.wudi then
			inst.wudi_fx = SpawnPrefab("forcefieldfx")
			inst.wudi_fx.entity:SetParent(inst.entity)
			inst.wudi_fx.Transform:SetPosition(0,0,0)
			inst.wudi_fx.persists = false
			inst.wudi_fx:DoTaskInTime(30, inst.wudi_fx.Remove)
			inst.components.health.absorb = 1
			inst:DoTaskInTime(30, function()
				inst.components.health.absorb = 0
			end)
		end
	end)
	
	
	inst.OnLoad = onload
    inst.OnNewSpawn = onload
end

return MakePlayerCharacter("suofeiya", prefabs, assets, common_postinit, master_postinit, start_inv)
