local function healowner(inst, owner)
    if ( owner.components.health and owner.components.health:IsHurt() ) then
        owner.components.health:DoDelta(1/6, false, "mengjiang")
    end
	--冰冻
	local x,y,z = owner.Transform:GetWorldPosition()
    local ents = TheSim:FindEntities(x,y,z,6)
	for k,v in pairs(ents) do
		if v and v.components.freezable and 
			v.components.health and not v.components.health:IsDead() and
			( v:HasTag("hostile") or v:HasTag("monster") or v:HasTag("epic") or (v.components.combat and v.components.combat.target == owner ) )
		then
			v.components.freezable:AddColdness(6)
			v.components.freezable:SpawnShatterFX()
		end
	end
	
end

local function OnEquip(inst, owner) 
	--if owner.userid == TUNING.SUOFEIYA_OKID then
	if true then
		owner.AnimState:OverrideSymbol("swap_hat", "hat_mengjiang", "swap_hat")

		owner.AnimState:Show("HAT")
		owner.AnimState:Show("HAT_HAIR")
		owner.AnimState:Hide("HAIR_NOHAT")
		owner.AnimState:Hide("HAIR")

		if owner:HasTag("player") then
			owner.AnimState:Hide("HEAD")
			owner.AnimState:Show("HEAD_HAT")
		end
		
		inst.task = inst:DoPeriodicTask(5, healowner, nil, owner)
		
		owner.components.locomotor:SetExternalSpeedMultiplier(owner, "mengjiang_speed_mod", 2)
	else
		owner:DoTaskInTime(0, function()
			local inv = owner.components.inventory 
			if inv then
				inv:GiveItem(inst)
			end
			local talker = owner.components.talker 
			if talker then
				talker:Say("我不是指定的用户ID!")
			end
		end)
	end
end

local function OnUnequip(inst, owner) 
    owner.AnimState:Hide("HAT")
    owner.AnimState:Hide("HAT_HAIR")
    owner.AnimState:Show("HAIR_NOHAT")
    owner.AnimState:Show("HAIR")

    if owner:HasTag("player") then
        owner.AnimState:Show("HEAD")
        owner.AnimState:Hide("HEAD_HAT")
    end
	
	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
	
	owner.components.locomotor:SetExternalSpeedMultiplier(owner, "mengjiang_speed_mod", 1)
end

local function fn()

    local inst = CreateEntity()
    
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("d_mengjiang")
    inst.AnimState:SetBuild("d_mengjiang")
    inst.AnimState:PlayAnimation("idle")

    inst:AddTag("hat")

    if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "mengjiang"
    inst.components.inventoryitem.atlasname = "images/mengjiang.xml"
    
    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
	--inst.components.equippable.walkspeedmult = 5
	
	inst:AddComponent("armor")
	inst.components.armor:InitCondition(600, .5)
	
	--[[
	inst:DoPeriodicTask(.25, function()
		local owner = inst.components.inventoryitem.owner
		if owner and owner.userid == TUNING.SUOFEIYA_OKID then
			inst.components.armor:InitCondition(999999999, 1)
		end
	end)]]
	
    return inst
end

return  Prefab("mengjiang", fn)