PrefabFiles = {
	"suofeiya",
	"mengjiang",
	"ciyuan",
	"huanxiang",
	
	"suofeiya_yezi", "suofeiya_projectile",
	"suofeiya_minerhatlight",
	
	"suofeiya_fenshen",
	"suofeiya_icerain_ele",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/suofeiya.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/suofeiya.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/suofeiya.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/suofeiya.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/suofeiya_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/suofeiya_silho.xml" ),

    Asset( "IMAGE", "bigportraits/suofeiya.tex" ),
    Asset( "ATLAS", "bigportraits/suofeiya.xml" ),
	
	Asset( "IMAGE", "images/map_icons/suofeiya.tex" ),
	Asset( "ATLAS", "images/map_icons/suofeiya.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_suofeiya.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_suofeiya.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_suofeiya.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_suofeiya.xml" ),
	
	----道具
	Asset( "ANIM", "anim/hat_mengjiang.zip" ),
	Asset( "ANIM", "anim/torso_ciyuan.zip" ),
	
	Asset( "ANIM", "anim/d_mengjiang.zip" ),
	Asset( "ANIM", "anim/d_ciyuan.zip" ),
	
	Asset( "ANIM", "anim/huanxiang.zip" ),
	Asset( "ANIM", "anim/swap_huanxiang.zip" ),
	
	Asset( "ATLAS", "images/mengjiang.xml" ),
	Asset( "ATLAS", "images/ciyuan.xml" ),
	Asset( "ATLAS", "images/huanxiang.xml" ),

}

-- Import the engine.
modimport("engine.lua")

-- Imports to keep the keyhandler from working while typing in chat.
Load "chatinputscreen"
Load "consolescreen"
Load "textedit"

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS

local COOK = GLOBAL.ACTIONS.COOK
local old_cook_fn = COOK.fn

local resolvefilepath = GLOBAL.resolvefilepath

local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local Recipe = GLOBAL.Recipe
local TECH = GLOBAL.TECH
local STRINGS = GLOBAL.STRINGS
local TUNING = GLOBAL.TUNING

local Player = GLOBAL.ThePlayer
local TheNet = GLOBAL.TheNet
local IsServer = GLOBAL.TheNet:GetIsServer()
local TheInput = GLOBAL.TheInput
local TimeEvent = GLOBAL.TimeEvent
local FRAMES = GLOBAL.FRAMES
local EQUIPSLOTS = GLOBAL.EQUIPSLOTS
local EventHandler = GLOBAL.EventHandler
local SpawnPrefab = GLOBAL.SpawnPrefab
local State = GLOBAL.State
local DEGREES = GLOBAL.DEGREES
local Vector3 = GLOBAL.Vector3
local ACTIONS = GLOBAL.ACTIONS
local FOODTYPE = GLOBAL.FOODTYPE
local PLAYERSTUNLOCK = GLOBAL.PLAYERSTUNLOCK
local GetTime = GLOBAL.GetTime
local HUMAN_MEAT_ENABLED = GLOBAL.HUMAN_MEAT_ENABLED
local TheSim = GLOBAL.TheSim

----------------------------------------------------------------------------ID-------------------------------------------------------------------------------------
--TUNING.SUOFEIYA_OKID = "OU_76561198254629175"		--大猪猪的ID
TUNING.SUOFEIYA_OKID = "KU_WDSGTEcW"		--月月妹纸的ID

-- The character select screen lines
STRINGS.CHARACTER_TITLES.suofeiya = "The Sample Character"
STRINGS.CHARACTER_NAMES.suofeiya = "Suofeiya"
STRINGS.CHARACTER_DESCRIPTIONS.suofeiya = "*Perk 1\n*Perk 2\n*Perk 3"
STRINGS.CHARACTER_QUOTES.suofeiya = "\"Quote\""

-- Custom speech strings
STRINGS.CHARACTERS.SUOFEIYA = require "speech_suofeiya"

-- The character's name as appears in-game 
STRINGS.NAMES.SUOFEIYA = "Suofeiya"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.SUOFEIYA = 
{
	GENERIC = "It's Suofeiya!",
	ATTACKER = "That Suofeiya looks shifty...",
	MURDERER = "Murderer!",
	REVIVER = "Suofeiya, friend of ghosts.",
	GHOST = "Suofeiya could use a heart.",
}


AddMinimapAtlas("images/map_icons/suofeiya.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("suofeiya", "FEMALE")

AddPrefabPostInit("suofeiya", function(inst)
	
end)

--配方--------------------------------------------------------------------------------
local mengjiang = AddRecipe("mengjiang",
{GLOBAL.Ingredient("nightmarefuel", 3), GLOBAL.Ingredient("purplegem", 1)}, 
GLOBAL.RECIPETABS.MAGIC, GLOBAL.TECH.NONE,
nil, nil, nil, nil, nil,
"images/mengjiang.xml", "mengjiang.tex")
STRINGS.RECIPE_DESC.MENGJIANG = "萌酱"
STRINGS.NAMES.MENGJIANG = "萌酱"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MENGJIANG = "萌酱."

local ciyuan = AddRecipe("ciyuan",
{GLOBAL.Ingredient("nightmarefuel", 3), GLOBAL.Ingredient("bluegem", 1)}, 
GLOBAL.RECIPETABS.MAGIC, GLOBAL.TECH.NONE,
nil, nil, nil, nil, nil,
"images/ciyuan.xml", "ciyuan.tex")
STRINGS.RECIPE_DESC.CIYUAN = "次元"
STRINGS.NAMES.CIYUAN = "次元"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.CIYUAN = "次元."

local huanxiang = AddRecipe("huanxiang",
{GLOBAL.Ingredient("nightmarefuel", 3), GLOBAL.Ingredient("redgem", 1)}, 
GLOBAL.RECIPETABS.MAGIC, GLOBAL.TECH.NONE,
nil, nil, nil, nil, nil,
"images/huanxiang.xml", "huanxiang.tex")
STRINGS.RECIPE_DESC.HUANXIANG = "幻想"
STRINGS.NAMES.HUANXIANG = "幻想"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HUANXIANG = "幻想."
--------------------------------------------------------------------------------------

--快速做饭
COOK.fn = function(act, ...)
    local result = old_cook_fn(act)
    local stewer = act.target.components.stewer
    if result and stewer ~= nil and act.doer.prefab == "suofeiya" then
        local fn = stewer.task.fn
        stewer.task:Cancel()
        fn(act.target, stewer)
    end
end
--多倍收获
AddPrefabPostInit("cookpot", function(inst)
    if inst.components.stewer == nil then
        return
    end
    -- using the same harvest logic and repeat the item giving step once
    local old_harvest = inst.components.stewer.Harvest
    inst.components.stewer.Harvest = function(self, harvester)
        if harvester and harvester.prefab == "suofeiya" then
            if self.done and self.product and harvester.components.inventory then
			
				local loot = nil
				local loot2 = nil
				local loot3 = nil
				local loot4 = nil
				local loot5 = nil
			
                loot = GLOBAL.SpawnPrefab(self.product)
				loot2 = GLOBAL.SpawnPrefab(self.product)
				
				if self.product == "meatballs" then
					loot3 = GLOBAL.SpawnPrefab(self.product)
					loot4 = GLOBAL.SpawnPrefab(self.product)
					loot5 = GLOBAL.SpawnPrefab(self.product)
				end
				
                if loot ~= nil then
                    if self.spoiltime ~= nil and loot.components.perishable ~= nil then
                        local spoilpercent = self:GetTimeToSpoil() / self.spoiltime
                        loot.components.perishable:SetPercent(self.product_spoilage * spoilpercent)
                        loot.components.perishable:StartPerishing()
                    end
                    harvester.components.inventory:GiveItem(loot, nil, self.inst:GetPosition())
					harvester:DoTaskInTime( 1*GLOBAL.FRAMES, function() 
						if harvester and harvester.components.inventory then
							harvester.components.inventory:GiveItem(loot2, nil, self.inst:GetPosition())
						end
					end)
					----若果是肉丸再多收三份
					if loot3 then
						harvester:DoTaskInTime( 2*GLOBAL.FRAMES, function() 
							if harvester and harvester.components.inventory then
								harvester.components.inventory:GiveItem(loot3, nil, self.inst:GetPosition())
							end
						end)
						harvester:DoTaskInTime( 3*GLOBAL.FRAMES, function() 
							if harvester and harvester.components.inventory then
								harvester.components.inventory:GiveItem(loot4, nil, self.inst:GetPosition())
							end
						end)
						harvester:DoTaskInTime( 4*GLOBAL.FRAMES, function() 
							if harvester and harvester.components.inventory then
								harvester.components.inventory:GiveItem(loot5, nil, self.inst:GetPosition())
							end
						end)
					end
					
                end
            end
        end
        return old_harvest(self, harvester)
    end
end)


----技能需要专属ID

--大丰收
local function x_skill(inst,x,y,z)

	if inst.components.talker then
		inst.components.talker:Say("大丰收")
	end

	--收获
	local x,y,z = inst.Transform:GetWorldPosition()
	local fxtable = {"sanity_raise","sanity_lower","statue_transition","statue_transition_2","shadow_despawn"}
	local ents = TheSim:FindEntities(x,y,z,30)
	--inst:StartThread(function()
		for k,v in pairs(ents) do
			if v.components.pickable and v:HasTag("pickable") then
				v.components.pickable:Pick(inst)
			elseif v.components.harvestable and v:HasTag("harvestable") then
				v.components.harvestable:Harvest(inst)
			elseif v.components.inventoryitem and v.components.inventoryitem.owner == nil then
				inst.components.inventory:GiveItem(v, nil, inst:GetPosition())
			end
			if v.Transform then
				SpawnPrefab(fxtable[math.random(#fxtable)]).Transform:SetPosition(Vector3(v.Transform:GetWorldPosition()):Get())
				--Sleep(.33)
			end
		end
	--end)
	
end
AddModRPCHandler("suofeiya", "x_skill", x_skill)

local function c_skill(inst,x,y,z)
	if inst.components.talker then
		inst.components.talker:Say("卖萌术")
	end
	
	for k, v in pairs(GLOBAL.AllPlayers) do
		if v and v.components.health and not v.components.health:IsDead() and not v:HasTag("playerghost") then
	
			if v.components.hunger then
				v.components.hunger:DoDelta(15)
			end
			--if v.components.health then
				v.components.health:DoDelta(10)
			--end
			if v.components.sanity then
				v.components.sanity:DoDelta(1)
			end
		end
	end
	
end
AddModRPCHandler("suofeiya", "c_skill", c_skill)

local function v_skill(inst,x,y,z)

	if inst.components.talker then
		inst.components.talker:Say("复活术")
	end

	for k, v in pairs(GLOBAL.AllPlayers) do
		if v and v:HasTag("playerghost") then
		
			v:PushEvent("respawnfromghost")
			if v.components.health then
				v.components.health:SetPercent(1)
			end
			if v.components.hunger then
				v.components.hunger:SetPercent(1)
			end
			if v.components.sanity then
				v.components.sanity:SetPercent(1)
			end
			
		end
	end
end
AddModRPCHandler("suofeiya", "v_skill", v_skill)


local function r_skill(inst,x,y,z)

	--if inst.components.talker then
	--	inst.components.talker:Say("抱头蹲防")
	--end

end
AddModRPCHandler("suofeiya", "r_skill", r_skill)


local function l_skill(inst,x,y,z)

	if inst.components.talker then
		inst.components.talker:Say("冰雨")
	end
	
	if inst.components.hunger then
		inst.components.hunger:DoDelta(15)
	end
	
	--冰雨元子在空中
	local offset = {}
	for i = -1, 1 do
		for j = -3, 3 do
			table.insert(offset, {x=i, z=j})
		end
	end
	for i = -2, 2 do
		table.insert(offset, {x=-2, z=i})
		table.insert(offset, {x=2, z=i})
	end
	for i = -1, 1 do
		table.insert(offset, {x=-3, z=i})
		table.insert(offset, {x=3, z=i})
	end
	
	local mult = 3
	for k,v in pairs(offset) do
		inst:DoTaskInTime(math.random()*5, function()
			local fire = SpawnPrefab("suofeiya_icerain_ele")
			fire.Transform:SetPosition(x+v.x*mult,15,z+v.z*mult)
			fire.master = inst
			fire.Physics:SetMotorVelOverride(0,-15,0)
		end)
	end

end
AddModRPCHandler("suofeiya", "l_skill", l_skill)


local function t_skill(inst,x,y,z)

	if inst.components.talker then
		inst.components.talker:Say("极乐净土")
	end
	
	local ents = TheSim:FindEntities(x,y,z,30)
	for k,v in pairs(ents) do
		if v and v.components.health and not v.components.health:IsDead() and v.components.combat and v ~= inst then
			if v:HasTag("player") and not v:HasTag("playerghost") then
				v.AnimState:PlayAnimation("emoteXL_loop_dance0", true)
				
				if v.suofeiya_dance_task == nil then
					v.suofeiya_dance_task = inst:DoPeriodicTask(2, function()
						if v.components.sanity then
							v.components.sanity:DoDelta(20)
						end
						if v.components.health then
							v.components.health:DoDelta(20)
						end
						if v.components.hunger then
							v.components.hunger:DoDelta(20)
						end
						if v.components.playercontroller then
							v.components.playercontroller:Enable(false)
						end
					end)
				end
				v:DoTaskInTime(20, function()
					if v.suofeiya_dance_task ~= nil then
						v.suofeiya_dance_task:Cancel()
						v.suofeiya_dance_task = nil
						if v.components.playercontroller then
							v.components.playercontroller:Enable(true)
						end
					end
				end)
			elseif v:HasTag("monster") or v:HasTag("hostile") or v:HasTag("epic") then
				v.components.combat:GetAttacked(inst, 100)
				if v.components.sleeper then
					v.components.sleeper:AddSleepiness(10, 10)
				end
			end
		end
	end

end
AddModRPCHandler("suofeiya", "t_skill", t_skill)











