RPGITEM = true

PrefabFiles = {
	"magnifyingglass",
	"poison_smoke",
}

STRINGS = GLOBAL.STRINGS
ACTIONS = GLOBAL.ACTIONS

-- [[ magnifying glass ]]

local temprecipe0 = GLOBAL.Recipe( "magnifyingglass", { GLOBAL.Ingredient("goldnugget", 1),  GLOBAL.Ingredient("log", 1) }, GLOBAL.RECIPETABS.TOOLS, {SCIENCE = 1})
temprecipe0.atlas = "images/inventoryimages/magnifyingglass.xml"

STRINGS.NAMES.MAGNIFYINGGLASS = "鉴定放大镜"
STRINGS.RECIPE_DESC.MAGNIFYINGGLASS = "仔细观察那些奇怪的东西"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MAGNIFYINGGLASS = {}
STRINGS.CHARACTERS.GENERIC.DESCRIBE.MAGNIFYINGGLASS.GENERIC = "一个重要的科学工具."
STRINGS.CHARACTERS.WX78.DESCRIBE.MAGNIFYINGGLASS = "凸透镜"
STRINGS.CHARACTERS.WILLOW.DESCRIBE.MAGNIFYINGGLASS = "谁在乎？"
STRINGS.CHARACTERS.WICKERBOTTOM.DESCRIBE.MAGNIFYINGGLASS = "我已经带着副眼镜了..."
STRINGS.CHARACTERS.WOLFGANG.DESCRIBE.MAGNIFYINGGLASS = "现在我是个侦探！"
STRINGS.CHARACTERS.WENDY.DESCRIBE.MAGNIFYINGGLASS = "我就看看不说话."

local MAGNIFYIDENTIFY = GLOBAL.Action()
MAGNIFYIDENTIFY.str = "鉴定"
MAGNIFYIDENTIFY.id = "MAGNIFYIDENTIFY"
MAGNIFYIDENTIFY.fn = function(act)
	if act.target and act.target.components.rpgweapon and act.target.components.rpgweapon.discovered == false and act.target.components.rpgweapon.currenttype ~= "nonmagic" and act.invobject and act.invobject.components.magnifyidentify then
		return act.invobject.components.magnifyidentify:DoIdentify(act.target, act.doer)
	end
	if act.target and act.target.components.rpgarmor and act.target.components.rpgarmor.discovered == false and act.target.components.rpgarmor.currenttype ~= "nonmagic" and act.invobject and act.invobject.components.magnifyidentify then
		return act.invobject.components.magnifyidentify:DoIdentify(act.target, act.doer)
	end
end

AddAction(MAGNIFYIDENTIFY)

local function magnifyid (inst, doer, target, actions, right)
	if right then
		if target:HasTag("unidentified") then
	        table.insert(actions, ACTIONS.MAGNIFYIDENTIFY)
	    end
	end
end
AddComponentAction("USEITEM", "magnifyidentify", magnifyid)

AddStategraphActionHandler("wilson", GLOBAL.ActionHandler(MAGNIFYIDENTIFY, "dolongaction"))
AddStategraphActionHandler("wilson_client", GLOBAL.ActionHandler(MAGNIFYIDENTIFY, "dolongaction"))

-- [[ effects ]]
STRINGS.RPGITEMS = {}
STRINGS.RPGITEMS.undiscovered = "这东西看上去有些与众不同...\n我应该仔细看看!"

STRINGS.RPGITEMS.WEAPONS = {}

STRINGS.RPGITEMS.WEAPONS.igniter = "有几率引燃目标 *"
STRINGS.RPGITEMS.WEAPONS.lifesteal = "击中时吸取生命"
STRINGS.RPGITEMS.WEAPONS.freezer = "有几率冻结目标 *"
STRINGS.RPGITEMS.WEAPONS.shrinker = "有几率降低目标速度 *"
STRINGS.RPGITEMS.WEAPONS.vorpal = "非常小几率秒杀目标 *"
STRINGS.RPGITEMS.WEAPONS.blessed = "20%附加伤害"
STRINGS.RPGITEMS.WEAPONS.sharp = "10%附加伤害"
STRINGS.RPGITEMS.WEAPONS.teleporter = "有几率将目标瞬移到其他地方 *"
STRINGS.RPGITEMS.WEAPONS.durable = "更结实耐用"
STRINGS.RPGITEMS.WEAPONS.terrifying = "有几率使目标恐慌 *"
STRINGS.RPGITEMS.WEAPONS.poisoning = "有几率造成双倍伤害 *"
STRINGS.RPGITEMS.WEAPONS.slippery = "使用时可能会脱手 *"
STRINGS.RPGITEMS.WEAPONS.disappearing = "使用时可能会消失 *"
STRINGS.RPGITEMS.WEAPONS.thorny = "使用时造成1点伤害"
STRINGS.RPGITEMS.WEAPONS.selfrepairing = "缓慢的自我修复"

STRINGS.RPGITEMS.WEAPONS.NAMES = {}
STRINGS.RPGITEMS.WEAPONS.NAMES.igniter = "燃烧"
STRINGS.RPGITEMS.WEAPONS.NAMES.lifesteal = "吸血"
STRINGS.RPGITEMS.WEAPONS.NAMES.freezer = "冰冻"
STRINGS.RPGITEMS.WEAPONS.NAMES.shrinker = "减速"
STRINGS.RPGITEMS.WEAPONS.NAMES.vorpal = "秒杀"
STRINGS.RPGITEMS.WEAPONS.NAMES.blessed = "祝福"
STRINGS.RPGITEMS.WEAPONS.NAMES.sharp = "精炼"
STRINGS.RPGITEMS.WEAPONS.NAMES.teleporter = "破空"
STRINGS.RPGITEMS.WEAPONS.NAMES.durable = "结实的"
STRINGS.RPGITEMS.WEAPONS.NAMES.terrifying = "恐惧"
STRINGS.RPGITEMS.WEAPONS.NAMES.poisoning = "暴击"
STRINGS.RPGITEMS.WEAPONS.NAMES.slippery = "湿滑的"
STRINGS.RPGITEMS.WEAPONS.NAMES.disappearing = "残破的"
STRINGS.RPGITEMS.WEAPONS.NAMES.thorny = "诅咒"
STRINGS.RPGITEMS.WEAPONS.NAMES.selfrepairing = "永恒"

STRINGS.RPGITEMS.ARMOR = {}

STRINGS.RPGITEMS.ARMOR.NAMES = {}
STRINGS.RPGITEMS.ARMOR.NAMES.durable = "结实的"
STRINGS.RPGITEMS.ARMOR.NAMES.fireproof = "防火"
STRINGS.RPGITEMS.ARMOR.NAMES.cozy = "防冻"
STRINGS.RPGITEMS.ARMOR.NAMES.dapperness = "冥想"
STRINGS.RPGITEMS.ARMOR.NAMES.selfrepairing = "永恒"
STRINGS.RPGITEMS.ARMOR.NAMES.healing = "治疗"
STRINGS.RPGITEMS.ARMOR.NAMES.fasting = "共生"
STRINGS.RPGITEMS.ARMOR.NAMES.hungry = "寄生"
STRINGS.RPGITEMS.ARMOR.NAMES.traveller = "轻巧的"
STRINGS.RPGITEMS.ARMOR.NAMES.slowpoke = "沉重的"
STRINGS.RPGITEMS.ARMOR.NAMES.brilliant = "智慧"
STRINGS.RPGITEMS.ARMOR.NAMES.insomniac = "诅咒"
STRINGS.RPGITEMS.ARMOR.NAMES.entombing = "寒冰"
STRINGS.RPGITEMS.ARMOR.NAMES.telelocating = "异次元"

STRINGS.RPGITEMS.ARMOR.durable = "更结实耐用"
STRINGS.RPGITEMS.ARMOR.fireproof = "减少1/3的燃烧伤害"
STRINGS.RPGITEMS.ARMOR.cozy = "小幅度防止冻结"
STRINGS.RPGITEMS.ARMOR.dapperness = "小幅度恢复理智"
STRINGS.RPGITEMS.ARMOR.selfrepairing = "缓慢的自我修复"
STRINGS.RPGITEMS.ARMOR.healing = "提供缓慢的治疗"
STRINGS.RPGITEMS.ARMOR.fasting = "不容易感到饥饿"
STRINGS.RPGITEMS.ARMOR.hungry = "更容易感到饥饿"
STRINGS.RPGITEMS.ARMOR.traveller = "提高速度"
STRINGS.RPGITEMS.ARMOR.slowpoke = "降低速度"
STRINGS.RPGITEMS.ARMOR.brilliant = "让你变得更聪明"
STRINGS.RPGITEMS.ARMOR.insomniac = "阻止你进入睡眠"
STRINGS.RPGITEMS.ARMOR.entombing = "有几率冻结攻击者 *"
STRINGS.RPGITEMS.ARMOR.telelocating = "有几率将攻击者传送到其他地方 *"

if GLOBAL.TheNet and GLOBAL.TheNet:GetIsServer() then

	function HF_addrpgweapon(inst)
		inst:AddComponent("rpgweapon")
		inst:AddComponent("named")
	end

	AddPrefabPostInit("axe", HF_addrpgweapon)
	AddPrefabPostInit("goldenaxe", HF_addrpgweapon)
	AddPrefabPostInit("hambat", HF_addrpgweapon)
	AddPrefabPostInit("spear", HF_addrpgweapon)
	AddPrefabPostInit("tentaclespike", HF_addrpgweapon)
	AddPrefabPostInit("nightsword", HF_addrpgweapon)
	AddPrefabPostInit("pickaxe", HF_addrpgweapon)
	AddPrefabPostInit("goldenpickaxe", HF_addrpgweapon)
	AddPrefabPostInit("fishingrod", HF_addrpgweapon)
	AddPrefabPostInit("bugnet", HF_addrpgweapon)
	AddPrefabPostInit("hammer", HF_addrpgweapon)
	AddPrefabPostInit("shovel", HF_addrpgweapon)
	AddPrefabPostInit("goldenshovel", HF_addrpgweapon)
	AddPrefabPostInit("pitchfork", HF_addrpgweapon)
	AddPrefabPostInit("cane", HF_addrpgweapon)
	AddPrefabPostInit("batbat", HF_addrpgweapon)
	AddPrefabPostInit("multitool_axe_pickaxe", HF_addrpgweapon)
	AddPrefabPostInit("ruins_bat", HF_addrpgweapon)
	--AddPrefabPostInit("eyeturret", HF_addrpgweapon)
	AddPrefabPostInit("onemanband", HF_addrpgweapon)
--	AddPrefabPostInit("panflute", HF_addrpgweapon)
	AddPrefabPostInit("icestaff", HF_addrpgweapon)
	AddPrefabPostInit("firestaff", HF_addrpgweapon)
	AddPrefabPostInit("telestaff", HF_addrpgweapon)
	AddPrefabPostInit("orangestaff", HF_addrpgweapon)
	AddPrefabPostInit("greenstaff", HF_addrpgweapon)
	AddPrefabPostInit("yellowstaff", HF_addrpgweapon)
	AddPrefabPostInit("staff_tornado", HF_addrpgweapon)
	-- DLC
	AddPrefabPostInit("spear_wathgrithr", HF_addrpgweapon)
	AddPrefabPostInit("minifan", HF_addrpgweapon)
	--MOD
	AddPrefabPostInit("ironwrench", HF_addrpgweapon)
	AddPrefabPostInit("crappywrench", HF_addrpgweapon)
	AddPrefabPostInit("hmsword", HF_addrpgweapon)
	AddPrefabPostInit("clyde", HF_addrpgweapon)
	AddPrefabPostInit("cactusmace", HF_addrpgweapon)
	AddPrefabPostInit("dark_axe", HF_addrpgweapon)
	AddPrefabPostInit("dark_pickaxe", HF_addrpgweapon)
	AddPrefabPostInit("flyswatter", HF_addrpgweapon)
	AddPrefabPostInit("fryingpan", HF_addrpgweapon)
	AddPrefabPostInit("growthstaff", HF_addrpgweapon)
	AddPrefabPostInit("spartaswurd", HF_addrpgweapon)
	AddPrefabPostInit("woodenmace", HF_addrpgweapon)
	AddPrefabPostInit("scythe", HF_addrpgweapon)
	AddPrefabPostInit("scythe_golden", HF_addrpgweapon)
	AddPrefabPostInit("gear_axe", HF_addrpgweapon)
	AddPrefabPostInit("gear_mace", HF_addrpgweapon)
	AddPrefabPostInit("gear_torch", HF_addrpgweapon)
	AddPrefabPostInit("cane_stick", HF_addrpgweapon)
	AddPrefabPostInit("iron_axe", HF_addrpgweapon)
	AddPrefabPostInit("iron_hammer", HF_addrpgweapon)
	AddPrefabPostInit("long_sword", HF_addrpgweapon)
	AddPrefabPostInit("magic_sword", HF_addrpgweapon)
	AddPrefabPostInit("short_sword", HF_addrpgweapon)
	AddPrefabPostInit("throwing_dagger", HF_addrpgweapon)
	AddPrefabPostInit("fireblade", HF_addrpgweapon)
	AddPrefabPostInit("shiruken", HF_addrpgweapon)
	AddPrefabPostInit("tungsten_axe", HF_addrpgweapon)
	AddPrefabPostInit("tungsten_pickaxe", HF_addrpgweapon)

	function HF_addrpgarmor(inst)
		inst:AddComponent("rpgarmor")
		inst:AddComponent("named")
	end
	AddPrefabPostInit("armorgrass", HF_addrpgarmor)
	AddPrefabPostInit("armor_sanity", HF_addrpgarmor)
	AddPrefabPostInit("umbrella", HF_addrpgarmor)
	AddPrefabPostInit("torch", HF_addrpgarmor)
	AddPrefabPostInit("armorwood", HF_addrpgarmor)
	AddPrefabPostInit("armormarble", HF_addrpgarmor)
	AddPrefabPostInit("sweatervest", HF_addrpgarmor)
	AddPrefabPostInit("trunkvest_summer", HF_addrpgarmor)
	AddPrefabPostInit("trunkvest_winter", HF_addrpgarmor)
	AddPrefabPostInit("armorsnurtleshell", HF_addrpgarmor)
	AddPrefabPostInit("nightlight", HF_addrpgarmor)
	AddPrefabPostInit("armorruins", HF_addrpgarmor)
	AddPrefabPostInit("armorslurper", HF_addrpgarmor)
	AddPrefabPostInit("earmuffshat", HF_addrpgarmor)
	AddPrefabPostInit("tophat", HF_addrpgarmor)
	AddPrefabPostInit("beefalohat", HF_addrpgarmor)
	AddPrefabPostInit("featherhat", HF_addrpgarmor)
	AddPrefabPostInit("beehat", HF_addrpgarmor)
	AddPrefabPostInit("minerhat", HF_addrpgarmor)
	AddPrefabPostInit("spiderhat", HF_addrpgarmor)
	AddPrefabPostInit("footballhat", HF_addrpgarmor)
	AddPrefabPostInit("winterhat", HF_addrpgarmor)
	AddPrefabPostInit("walrushat", HF_addrpgarmor)
	AddPrefabPostInit("slurtlehat", HF_addrpgarmor)
	AddPrefabPostInit("ruinshat", HF_addrpgarmor)
	AddPrefabPostInit("strawhat", HF_addrpgarmor)
	AddPrefabPostInit("lantern", HF_addrpgarmor)
	-- DLC
	AddPrefabPostInit("wathgrithrhat", HF_addrpgarmor)
	AddPrefabPostInit("icehat", HF_addrpgarmor)
	AddPrefabPostInit("rainhat", HF_addrpgarmor)
	AddPrefabPostInit("catcoonhat", HF_addrpgarmor)
	AddPrefabPostInit("watermelonhat", HF_addrpgarmor)
	AddPrefabPostInit("grass_umbrella", HF_addrpgarmor)
	AddPrefabPostInit("beargervest", HF_addrpgarmor)
	AddPrefabPostInit("armordragonfly", HF_addrpgarmor)
	AddPrefabPostInit("hawaiianshirt", HF_addrpgarmor)
	AddPrefabPostInit("raincoat", HF_addrpgarmor)
	AddPrefabPostInit("eyebrellahat", HF_addrpgarmor)
	AddPrefabPostInit("molehat", HF_addrpgarmor)
	--MOD
	AddPrefabPostInit("armormosquito", HF_addrpgarmor)
	AddPrefabPostInit("baronsuit", HF_addrpgarmor)
	AddPrefabPostInit("birchnuthat", HF_addrpgarmor)
	AddPrefabPostInit("ewecushat", HF_addrpgarmor)
	AddPrefabPostInit("hollowhat", HF_addrpgarmor)
	AddPrefabPostInit("lightnecklace", HF_addrpgarmor)
	AddPrefabPostInit("spartahelmut", HF_addrpgarmor)
	AddPrefabPostInit("summerbandana", HF_addrpgarmor)
	AddPrefabPostInit("hat_bee_bw", HF_addrpgarmor)
	AddPrefabPostInit("gear_armor", HF_addrpgarmor)
	AddPrefabPostInit("gear_hat", HF_addrpgarmor)
	AddPrefabPostInit("gear_helmet", HF_addrpgarmor)
	AddPrefabPostInit("gear_mask", HF_addrpgarmor)
	AddPrefabPostInit("gear_wings", HF_addrpgarmor)
	AddPrefabPostInit("gold_armor", HF_addrpgarmor)
	AddPrefabPostInit("victorian_suit", HF_addrpgarmor)
	AddPrefabPostInit("armor_tungsten", HF_addrpgarmor)
	AddPrefabPostInit("tungsten_hardhat", HF_addrpgarmor)



	-- add our text so when an item is examined it shows up if needed
	function rpgweaponinspectable(inst)
		local oldGetDescription = inst.GetDescription
		inst.GetDescription = function (self, viewer)
			local oldtext = oldGetDescription(self, viewer)
			if self.inst.components.rpgweapon and self.inst.components.rpgweapon:ReturnString() ~=nil then
				local returntext = self.inst.components.rpgweapon:ReturnString()
				if viewer.prefab == "wx78" then
					returntext = string.upper(returntext)
				end
				if viewer.prefab == "wes" then
					returntext = ""
				end
				return oldtext .. returntext
			elseif self.inst.components.rpgarmor and self.inst.components.rpgarmor:ReturnString() ~=nil then
				local returntext = self.inst.components.rpgarmor:ReturnString()
				if viewer.prefab == "wx78" then
					returntext = string.upper(returntext)
				end
				if viewer.prefab == "wes" then
					returntext = ""
				end
				return oldtext .. returntext
			else
				return oldtext 
			end

		end
	end
	AddComponentPostInit("inspectable", rpgweaponinspectable)

end -- GetIsServer()
