local assets=
{
	Asset("ANIM", "anim/thg.zip"),
	Asset("ATLAS", "images/inventoryimages/thg.xml"),
}

local prefabs =
{
	"spoiled_food",
}
local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	
	inst.entity:AddNetwork()
	
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBuild("thg")
    inst.AnimState:SetBank("berryshake")
    inst.AnimState:PlayAnimation("idle")
    
	if not TheWorld.ismastersim then
        return inst
    end

    inst.entity:SetPristine()
	
    inst:AddComponent("edible")
	inst.components.edible.foodtype = "GENERIC"
	
    inst.components.edible.healthvalue = 20
    inst.components.edible.hungervalue = 45
	inst.components.edible.sanityvalue = 15
	--inst.components.edible.temperaturedelta = TUNING.COLD_FOOD_BONUS_TEMP
	--inst.components.edible.temperatureduration = TUNING.FOOD_TEMP_AVERAGE

    inst:AddComponent("stackable")
	inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("tradable")

    inst:AddComponent("inspectable")
    
	inst:AddComponent("perishable")
	inst.components.perishable:SetPerishTime(TUNING.PERISH_FAST)
	inst.components.perishable:StartPerishing()
	inst.components.perishable.onperishreplacement = "spoiled_food"
    
    
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/thg.xml"
    
    return inst
end

return Prefab("common/inventory/thg", fn, assets, prefabs) 