
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),

        Asset( "ANIM", "anim/hqg.zip" ),
        Asset( "ANIM", "anim/ghost_hqg_build.zip" ),
		   Asset("SOUNDPACKAGE", "sound/huaqiangu.fev"),
	Asset("SOUND", "sound/huaqiangu.fsb"),
}
local prefabs = {}



-- Custom starting items
local start_inv = {
	"ice",
	"ice",
	"ice"
}

-- When the character is revived from human
local function onbecamehuman(inst)
	-- Glace is really fast
	inst.components.locomotor.walkspeed = 8
	inst.components.locomotor.runspeed = 10
end

-- When loading or spawning the character
local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)

    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
    end
end

-- This initializes for both the server and client. Tags can be added here.
local common_postinit = function(inst)
	-- Glace is so cold that all his items are cooled.
	inst:AddTag("fridge")
	inst.MiniMapEntity:SetIcon( "hqg.tex" )
end

-- This initializes for the server only. Components are added here.
local master_postinit = function(inst)
	-- choose which sounds this character will play
	inst.soundsname = "huaqaingu"
	
	-- Stats	
	inst.components.health:SetMaxHealth(200)
	inst.components.hunger:SetMax(150)
	inst.components.sanity:SetMax(150)
	
inst.soundsname = "hqg"
inst.entity:AddSoundEmitter()
	-- Can't overheat, but is very vunerable to the cold
	inst.components.temperature.mintemp = 1
	inst.components.temperature.maxtemp = 35
	inst.components.temperature.hurtrate = 1
	inst.components.temperature.rate = 1
	
	-- Glace is a bit troubled by the dark. 
	inst.components.sanity.night_drain_mult = 1
	
	-- Damage multiplier
    	inst.components.combat.damagemultiplier = 1

	-- Glace is a freezer, so...
	--inst:AddComponent("heater")
	--inst.components.heater.heatfn = function() return -35 end
	--inst.components.heater:SetThermics(false, true)
	
	-- Hunger rate; Glace has very good hunger management
	inst.components.hunger.hungerrate = 1 * TUNING.WILSON_HUNGER_RATE

	inst.OnLoad = onload
    	inst.OnNewSpawn = onload

	-- Glace likes to be among others. It makes him forget his worries.
	--inst:DoPeriodicTask(2, function()
		--local x, y, z = inst.Transform:GetWorldPosition()
		--local ents = TheSim:FindEntities(x, y, z, 4 ,{"player"})
		--if table.getn(ents) > 1 then
			--inst.components.sanity.night_drain_mult = 0
			--inst.components.sanity.current = inst.components.sanity.current + 5
		--else
			--inst.components.sanity.night_drain_mult = 2.5
		--end
	--end) 

	-- Butterflies are not fond of Glace
	inst:DoPeriodicTask(1, function()
		local x, y, z = inst.Transform:GetWorldPosition()
		local ents = TheSim:FindEntities(x, y, z, 2 ,{"butterfly"})
		for k, v in pairs(ents) do
			if not v.components.freezable:IsFrozen() then
				v.components.freezable:Freeze(3)
				SpawnPrefab("ice_puddle")
			end
		end
	end)
end

return MakePlayerCharacter("hqg", prefabs, assets, common_postinit, master_postinit, start_inv)
