local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
local STRINGS = GLOBAL.STRINGS
local Recipe = GLOBAL.Recipe 
local Action = GLOBAL.Action
local ActionHandler = GLOBAL.ActionHandler 
modimport("scripts/cookpotfix.lua")
PrefabFiles = {
	"hqg",
	"lgq",
	"dn",
	"tsd",
	"thg",
}


Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/hqg.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/hqg.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/hqg.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/hqg.xml" ),
	
    Asset( "IMAGE", "images/selectscreen_portraits/hqg_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/hqg_silho.xml" ),

    Asset( "IMAGE", "bigportraits/hqg.tex" ),
    Asset( "ATLAS", "bigportraits/hqg.xml" ),
	
	Asset( "IMAGE", "images/map_icons/hqg.tex" ),
	Asset( "ATLAS", "images/map_icons/hqg.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_hqg.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_hqg.xml" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_hqg.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_hqg.xml" ),
	
	   Asset("SOUNDPACKAGE", "sound/huaqiangu.fev"),
	Asset("SOUND", "sound/huaqiangu.fsb"),
	
    Asset("SOUNDPACKAGE", "sound/liuguangqing.fev"),
	Asset("SOUND", "sound/liuguangqing.fsb"),

}
RemapSoundEvent( "dontstarve/zg/lgq", "liuguangqing/sound/lgq" )
RemapSoundEvent( "dontstarve/characters/hqg/death_voice", "huaqiangu/sound/death_voice" )
RemapSoundEvent( "dontstarve/characters/hqg/hurt", "huaqiangu/sound/hurt" )
RemapSoundEvent( "dontstarve/characters/hqg/talk_LP", "huaqiangu/sound/talk_LP" )

STRINGS.NAMES.LGQ = "流光琴"
STRINGS.RECIPE_DESC.LGQ = "东方流光琴，净化涅槃。代表“善”与“重生”之物"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.LGQ = "圆圈勾勒成指纹" 
STRINGS.NAMES.DN = "断念剑"
STRINGS.RECIPE_DESC.DN = "断情不问天边月， 坐等秦时再相见， 也只一线间"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.DN = "不相信正义，不相信邪恶，可是我相信你" 
STRINGS.NAMES.TSD = "天水滴"
STRINGS.RECIPE_DESC.TSD = "由凤凰眼泪凝聚而成"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.TSD = "糖宝，你在吗" 
-- The character select screen lines
STRINGS.CHARACTER_TITLES.hqg = "小骨"
STRINGS.CHARACTER_NAMES.hqg = "花千骨"
STRINGS.CHARACTER_DESCRIPTIONS.hqg = "* 能够制作流光琴，断念剑\n* 不怕冷热\n* 能够制作桃花羹"
STRINGS.CHARACTER_QUOTES.hqg = "\"世间最后一个神\""
STRINGS.NAMES.THG = "桃花羹"
STRINGS.CHARACTERS.GENERIC.DESCRIBE.THG = "师傅，尝尝小骨为你做的桃花羹"
AddIngredientValues({"petals"}, {petals = 1})
-- Custom speech strings
STRINGS.CHARACTERS.HQG = require "speech_hqg"

-- The character's name as appears in-game 
STRINGS.NAMES.HQG = "hqg"

-- The default responses of examining the character
STRINGS.CHARACTERS.GENERIC.DESCRIBE.HQG = 
{
	GENERIC = "我不负长留，不负六界，不负天地，可是终归还是负了她负了我自己",
	ATTACKER = "想要救六界生灵?唯一的办法，杀了我",
	MURDERER = "我以神的名义诅咒你",
	REVIVER = "就算这世上没人爱你，你也要好好爱自己……",
	GHOST = "骨头，我来接你回家……",
}


AddMinimapAtlas("images/map_icons/hqg.xml")

-- Add mod character to mod character list. Also specify a gender. Possible genders are MALE, FEMALE, ROBOT, NEUTRAL, and PLURAL.
AddModCharacter("hqg", "FEMALE")
local thgrecipe =
		{
			name = "thg",
			--test = function(cooker, names, tags) return tags.berries and berries and tags.berries and tags.berries end,
			--priority = 10,
			--weight = 1,
			--foodtype = "VEGGIE",
			--health = 20,
			--hunger = 45,
			--sanity = 15,
			--perishtime = TUNING.PERISH_PRESERVED,
	      --inst.components.edible.temperaturedelta = TUNING.COLD_FOOD_BONUS_TEMP
	      --inst.components.edible.temperatureduration = TUNING.FOOD_TEMP_AVERAGE
			--cooktime = .1,
			test = function(cooker, names, tags)  return names.butterflywings and tags.frozen and names.twigs and names.petals end,
		priority = 1,
		foodtype = "VEGGIE",
		weight = 1,
		health = TUNING.HEALING_MED,
		hunger = TUNING.CALORIES_LARGE,
		perishtime = TUNING.PERISH_PRESERVED,
		sanity = TUNING.SANITY_MED,
		cooktime = .1,
		}
		
		AddCookerRecipe("cookpot", thgrecipe)



function load()
local lgq = GLOBAL.Recipe("lgq", {Ingredient("rope", 2), Ingredient("silk", 4),Ingredient("bluegem", 1),}, RECIPETABS.WAR, {SCIENCE=2})
lgq.atlas = "images/inventoryimages/lgq.xml"
local dn = GLOBAL.Recipe("dn", {Ingredient("petals", 1), Ingredient("twigs", 2), Ingredient("cutgrass", 5),}, RECIPETABS.WAR, {SCIENCE=1})
dn.atlas = "images/inventoryimages/dn.xml"
local tsd = GLOBAL.Recipe("tsd", {Ingredient("seeds", 1), Ingredient("ice", 2),}, RECIPETABS.WAR, {SCIENCE=1})
tsd.atlas = "images/inventoryimages/tsd.xml"
end
AddGamePostInit(load)

