local revealer = Class(function(self, inst)
    self.inst = inst
	self.period = 1
    self.radius = 0
end)

function revealer:StartUpdating()
	if self.task == nil then
        self.task = self.inst:DoPeriodicTask(self.period, function() self:DoUpdate() end, 0)
    end
end

local offset = 10.0

function revealer:getMapData()
	local mode = SaveGameIndex:GetCurrentMode()
	local cworld = SaveGameIndex:GetSlotWorld()
	if self.data == nil then self.data = {} end
	if self.data[mode] == nil then 
		if mode == "cave" then
			self.data.cave = {}
		else
			self.data[mode] = {world=0, data={}} 
			
		end
	end
	if (mode ~= "cave") and (self.data[mode].world ~= cworld) then
		self.data[mode] = {world=cworld, data={}}
		if mode == "survival" then
			self.data.cave = {}
		end
	end
	local mapdata = {}
	if mode == "cave" then
		local cavenum = SaveGameIndex:GetCurrentCaveNum()
		if self.data.cave[cavenum] == nil then
			self.data.cave[cavenum] = {}
		end
		local level = SaveGameIndex:GetCurrentCaveLevel()
		if self.data.cave[cavenum][level] == nil then
			self.data.cave[cavenum][level] = {}
		end
		mapdata = self.data.cave[cavenum][level]
	else
		mapdata = self.data[mode].data
	end
	if self.map == nil then
		self.map = TheSim:FindFirstEntityWithTag("minimap")
		for x, ycourds in pairs(mapdata) do
			for y, v in pairs(ycourds) do
				self.map.MiniMap:ShowArea(x*offset,0,y*offset,self.radius)
			end
		end
	end
	return mapdata
end



function revealer:DoUpdate()

	local mapdata = self:getMapData()
	
	local x,z,y = self.inst.Transform:GetWorldPosition()
	self.map.MiniMap:ShowArea(x,z,y,self.radius)
    x = math.floor(x/offset)
    y = math.floor(y/offset)
	
	if not mapdata[x] then mapdata[x] = {} end
	mapdata[x][y] = true
end

function revealer:OnSave()
	return self.data
end

function revealer:OnLoad(data)  
	self.data = data
end


return revealer