-- Revealer by No_Signal
-- Mod by Kiopho
---------------------------------------------------------------------------------------------------------------------------
local FOVdefault = (GetModConfigData("FOV")=="default")
local FOV40 = (GetModConfigData("FOV")=="FOV40")
local FOV45 = (GetModConfigData("FOV")=="FOV45")

local FollowCamera = GLOBAL.require("cameras/followcamera")
local default = FollowCamera.SetDefault

FollowCamera.SetDefault = function (self)
	default(self)
	
	if FOVdefault then
		self.fov = 35
	elseif FOV40 then
		self.fov = 40
	elseif FOV45 then
		self.fov = 45
	end
end

local function addRevealer(inst)
	inst:AddComponent("components/revealer")
	
	if FOVdefault then
		inst.components.revealer.radius = 60
	elseif FOV40 then
		inst.components.revealer.radius = 66
	elseif FOV45 then
		inst.components.revealer.radius = 72
	end
	
	inst.components.revealer:StartUpdating()
end

for k,prefabname in ipairs(CHARACTERLIST) do
	--AddPrefabPostInit(prefabname, addRevealer)
end

if GLOBAL.MODCHARACTERLIST then
	for k,prefabname in ipairs(GLOBAL.MODCHARACTERLIST) do
		--AddPrefabPostInit(prefabname, addRevealer)
	end
end