local assets =
{
    Asset("ANIM", "anim/whiteamulet.zip"),
	 Asset("ANIM", "anim/torso_whitegem.zip"),
	Asset("ATLAS", "images/inventoryimages/whiteamulet.xml"),
	Asset("IMAGE", "images/inventoryimages/whiteamulet.tex"),
}

local prefabs = 
{
 

}

local function turnoffspeed(inst)

	inst.components.locomotor.externalspeedmultiplier = 1
inst:RemoveTag("slowed")
    end


local function MeteorChance(owner, data)


 if data.attacker and data.attacker.components.locomotor and not data.attacker:HasTag("slowed") then
		data.attacker.components.locomotor.externalspeedmultiplier = 0.75
		data.attacker:AddTag("slowed")
		data.attacker:DoTaskInTime(5, turnoffspeed)
	end
end





local function onequip(inst, owner)
    owner.AnimState:OverrideSymbol("swap_body", "torso_whitegem", "blueamulet")
   inst:ListenForEvent("attacked", MeteorChance, owner)

	   if inst.components.fueled then
        inst.components.fueled:StartConsuming()
    end
	
end

local function onunequip(inst, owner)
    owner.AnimState:ClearOverrideSymbol("swap_body")


    inst:RemoveEventCallback("attacked", MeteorChance, owner)
	
	    if inst.components.fueled then
        inst.components.fueled:StopConsuming()
    end
 
end


local function fn()
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()

	MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("amulets")
    inst.AnimState:SetBuild("whiteamulet")
    inst.AnimState:PlayAnimation("blueamulet")
	
    inst.entity:SetPristine()

	if not TheWorld.ismastersim then
		return inst
	end


    inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.MAGIC
    inst.components.fueled:InitializeFuelLevel(TUNING.RAINCOAT_PERISHTIME * 0.5)
    inst.components.fueled:SetDepletedFn(inst.Remove)
	
	inst:AddComponent("inspectable")
	inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "whiteamulet"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/whiteamulet.xml"
	



	

	

	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.BODY
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_TINY
		inst.components.equippable.walkspeedmult = 1.1

	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )

	MakeHauntableLaunch(inst)

	return inst
end

return Prefab( "whiteamulet", fn, assets, prefabs)
