local assets=
{
    Asset("ANIM", "anim/marblemace.zip"),
    Asset("ANIM", "anim/swap_marblemace.zip"),
 
    Asset("ATLAS", "images/inventoryimages/marblemace.xml"),
    Asset("IMAGE", "images/inventoryimages/marblemace.tex"),
}

prefabs = {
}

local function onfinished(inst)
    inst:Remove()
end

 local function onattack(inst, attacker, target)

	local pt = target:GetPosition()    
  local ents = TheSim:FindEntities(pt.x, pt.y, pt.z, 1.8)
    for i, v in ipairs(ents) do
	if v ~= attacker then
  			
			 if v:HasTag("player") or v == target then
      
			  
            elseif v.components.health ~= nil then
			 v.components.combat:GetAttacked(attacker, 20, attacker, "wind")
	 v.components.combat:SuggestTarget(attacker)
end
end
end
end




    local function OnEquip(inst, owner)
        owner.AnimState:OverrideSymbol("swap_object", "swap_marblemace", "swap_marblemace")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")

    end
	
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end


local function fn(sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
     
    anim:SetBank("marblemace")
    anim:SetBuild("marblemace")
    anim:PlayAnimation("idle")

    inst:AddTag("sharp")


      if not TheWorld.ismastersim then
        return inst
    end


    inst:AddComponent("inspectable")
	inst.entity:SetPristine()
	


    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(40)
	inst.components.weapon:SetRange(1.5)
    inst.components.weapon:SetOnAttack(onattack)


     
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "marblemace"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/marblemace.xml"
     
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
    inst.components.equippable.walkspeedmult = 0.90
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(500)
    inst.components.finiteuses:SetUses(500)
    inst.components.finiteuses:SetOnFinished(onfinished)

            MakeHauntableLaunch(inst)
 
    return inst
end

return  Prefab("common/inventory/marblemace", fn, assets, prefabs)