local assets =
{
    Asset("ANIM", "anim/marblejavelin.zip"),
    Asset("ANIM", "anim/swap_marblejavelin.zip"),	
	Asset("ANIM", "anim/javelin_projectile.zip"),	
	
	Asset("ATLAS", "images/inventoryimages/marblejavelin.xml"),
    Asset("IMAGE", "images/inventoryimages/marblejavelin.tex"),
}

--COMBATSWORD

local function onequipjavelin(inst, owner)
    owner.AnimState:OverrideSymbol("swap_object", "swap_marblejavelin", "swap_marblejavelin")
    owner.AnimState:Show("ARM_carry")
    owner.AnimState:Hide("ARM_normal")
end

local function onunequipjavelin(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function OnDropped(inst)
    inst.AnimState:SetBank("marblejavelin")
    inst.AnimState:SetBuild("marblejavelin")
    inst.AnimState:PlayAnimation("idle")
end

local function OnUnequip(inst, owner)
    owner.AnimState:Hide("ARM_carry")
    owner.AnimState:Show("ARM_normal")
end

local function OnThrown(inst, owner, target)
    if target ~= owner then
		owner.SoundEmitter:PlaySound("dontstarve/wilson/attack_weapon")
    end
	inst.AnimState:SetBank("javelin_projectile")
    inst.AnimState:SetBuild("javelin_projectile")
    inst.AnimState:PlayAnimation("idle", true)
	inst.AnimState:SetOrientation( ANIM_ORIENTATION.OnGround )
end

local function OnHit(inst, owner, target)
    if owner == target or owner:HasTag("playerghost") then
        OnDropped(inst)
    end
    if target ~= nil and target:IsValid() then
        local impactfx = SpawnPrefab("impact")
        if impactfx ~= nil then
            local follower = impactfx.entity:AddFollower()
            follower:FollowSymbol(target.GUID, target.components.combat.hiteffectsymbol, 0, 0, 0)
            impactfx:FacePoint(inst.Transform:GetWorldPosition())
        end
    end
	inst.AnimState:SetBank("javelin")
    inst.AnimState:SetBuild("javelin")
    inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetOrientation( ANIM_ORIENTATION.Default )
	inst:Remove()
end

local function OnMiss(inst, owner, target)
    if owner == target then
        OnDropped(inst)
    end
	inst.AnimState:SetBank("marblejavelin")
    inst.AnimState:SetBuild("marblejavelin")
    inst.AnimState:PlayAnimation("idle")
	inst.AnimState:SetOrientation( ANIM_ORIENTATION.Default )
end

local function combat(bank, build)

    local inst = CreateEntity()

    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("marblejavelin")
    inst.AnimState:SetBuild("marblejavelin")
    inst.AnimState:PlayAnimation("idle")

	inst:AddTag("thrown")
	inst:AddTag("projectile")
	
	inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(30)
    inst.components.weapon:SetRange(7,15)

	
	inst:AddComponent("stackable")
    inst.components.stackable.maxsize = 20
	
	inst:AddComponent("projectile")
    inst.components.projectile:SetSpeed(25)
    inst.components.projectile:SetOnThrownFn(OnThrown)
    inst.components.projectile:SetOnHitFn(OnHit)
    inst.components.projectile:SetOnMissFn(OnMiss)
	inst.components.projectile:SetLaunchOffset( {x=0, y=2} )

	
    -------
	

    inst:AddComponent("inspectable")

    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "marblejavelin"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/marblejavelin.xml"
	
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(onequipjavelin)
    inst.components.equippable:SetOnUnequip(onunequipjavelin)
	inst.components.equippable.equipstack = true

    MakeHauntableLaunch(inst)

    return inst
end
--
return Prefab("common/inventory/marblejavelin", combat, assets)