local Autoclean = Class(function(self, inst)
	self.inst = inst
	self.perishtime = nil
	self.updatetask = nil
	self.perishremainingtime = nil
end)

local function Update(inst, dt)

    if inst.components.autoclean then
		local owner = nil 
		owner = inst.components.inventoryitem 
		and inst.components.inventoryitem.owner or nil
			
		if not owner and inst.components.occupier then
			owner = inst.components.occupier:GetOwner()
		end
			if not owner and (inst:HasTag("dropitem123") or inst.prefab == "spoiled_food") then
			
				if inst.components.autoclean.perishremainingtime then
						
						inst.components.autoclean.perishremainingtime = inst.components.autoclean.perishremainingtime - 1
						if inst.components.autoclean.perishremainingtime <= 0 then
							inst.components.autoclean:Perish()
						end					
				end
				
			else 
				inst.components.autoclean.perishremainingtime = inst.components.autoclean.perishtime
			end	
		
    end
	
end

function Autoclean:OnRemoveEntity()
	self:StopPerishing()
end

function Autoclean:Perish()
    if self.updatetask ~= nil then
        self.updatetask:Cancel()
        self.updatetask = nil
    end
	if self.inst then
		self.inst:Remove()
	end
end

function Autoclean:SetPerishTime(time)
	self.perishtime = time
	self.perishremainingtime = time
    if self.updatetask ~= nil then
        self:StartPerishing()
    end
end

function Autoclean:StartPerishing()
    if self.updatetask ~= nil then
        self.updatetask:Cancel()
        self.updatetask = nil
    end
    self.updatetask = self.inst:DoPeriodicTask(1, Update)
end

function Autoclean:StopPerishing()
    if self.updatetask ~= nil then
        self.updatetask:Cancel()
        self.updatetask = nil
    end
end

function Autoclean:OnSave()
    return
    {
        paused = self.updatetask == nil or nil,
        time = self.perishremainingtime,
    }
end

function Autoclean:OnLoad(data)
    if data ~= nil and data.time ~= nil then
        self.perishremainingtime = data.time
        if not data.paused then
            self:StartPerishing()
        end
    end
end

return Autoclean