-- This information tells other players more about the mod
name = "Advanced World Generation"
description = "Enables the user to heavily modify World Generation Process."
author = "Deja Vu"
version = "2.3.5"
version_compatible = "2.3.0"

-- This is the URL name of the mod's thread on the forum; the part after the index.php? and before the first & in the URL
-- Example:
-- http://forums.kleientertainment.com/index.php?/files/file/202-sample-mods/
-- becomes
-- /files/file/202-sample-mods/
forumthread = ""

-- This lets other players know if your mod is out of date, update it to match the current version in the game
api_version = 10

--This lets the clients know that they need to download the mod before they can join a server that is using it.
all_clients_require_mod = true

--This let's the game know that this mod doesn't need to be listed in the server's mod listing
client_only_mod = false

--Let the mod system know that this mod is functional with Don't Starve Together
dst_compatible = true

--These tags allow the server running this mod to be found with filters from the server listing screen
server_filter_tags = {"environment","worldgen"}

--Adds an icon to the mod
icon_atlas = "preview.xml"
icon = "preview.tex"

configuration_options =
{
-- World Options
	{
		name = "",
		label = "WORLD OPTIONS",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "GlobalBiomeSize",
		label = "Global Biome Sizes",
			hover = "Change the size of the world. Larger map requires powerful Server",
		options =	{
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 3,
	},
	{
		name = "LightsOutStartingItems",
		label = "Lights Out Mod Starting Items",
			hover = "Adds essential Lights Out game mode Starting Items",
		options =	{
						{description = "Disabled", data = 0},
						{description = "Enabled", data = 1},
					},
		default = 0,
	},
	{
		name = "OverworldNightmarePhase",
		label = "Overworld Nightmare Phase",
			hover = "Enable or disable Nightmare Phase in overworld",
		options =	{
						{description = "Disabled", data = 0},
						{description = "Enabled", data = 1},
					},
		default = 1,
	},
-- Enable or Disable Biomes
	{
		name = "",
		label = "",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "",
		label = "BIOME SETTINGS",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "RandomOptionalBiomes",
		label = "Random Optional Biomes",
			hover = "Randomly chooses extra biomes",
		options =	{
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
					},
		default = 6,
	},
	{
		name = "RandomOptionalCaveBiomes",
		label = "Random Optional Cave Biomes",
			hover = "Randomly chooses extra Cave biomes",
		options =	{
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
					},
		default = 8,
	},
	{
		name = "InfusedWorldsRandomOptionalBiomes",
		label = "Random Optional Infused World Biomes",
			hover = "Randomly chooses extra biomes for Infused World",
		options =	{
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "21", data = 21},
						{description = "22", data = 22},
						{description = "23", data = 23},
						{description = "24", data = 24},
						{description = "25", data = 25},
						{description = "26", data = 26},
						{description = "27", data = 27},
						{description = "28", data = 28},
						{description = "29", data = 29},
						{description = "30", data = 30},
					},
		default = 15,
	},
-- Biome Specific Settings
	{
		name = "",
		label = "",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "",
		label = "BIOME SPECIFIC SETTINGS",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "MooseSpawn",
		label = "Moose Spawn",
			hover = "Moose Spawn Eggs",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
					},
		default = 9,
	},
	{
		name = "DragonflySpawn",
		label = "Dragonfly Spawn",
			hover = "Dragonfly Spawn Arena",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
					},
		default = 1,
	},
	{
		name = "AncientGuardianSpawn",
		label = "Ancient Guardian Spawn",
			hover = "Ancient Guardian Spawn Arena",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
					},
		default = 1,
	},
-- Set Pieces Options
	{
		name = "",
		label = "",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "",
		label = "SET PIECES OPTIONS",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "",
		label = "Default Set Pieces",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
-- Default Biomes Set Pieces
	{
		name = "ResurrectionStoneOption",
		label = "Resurrection Stone",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "FarmplotOption",
		label = "Farmplot",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 8,
	},
	{
		name = "StoneHengeOption",
		label = "Stonehenge",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 8,
	},
	{
		name = "SimpleBaseOption",
		label = "Simple Base",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "RuinedBaseOption",
		label = "Ruined Base",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "GrottoOption",
		label = "Grotto",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 20,
	},
	{
		name = "LivingTreeOption",
		label = "Living Tree",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "MacTuskTownOption",
		label = "MacTusk Town",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "MacTuskCityOption",
		label = "MacTusk City",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "MermShrineOption",
		label = "Merm Shrine",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 0,
	},
	{
		name = "PigShrineOption",
		label = "Pig Shrine",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 0,
	},
	{
		name = "VillageSquareOption",
		label = "Village Square",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "PigGuardsOption",
		label = "Pig Guards",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "PigTownOption",
		label = "Pig Town",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "DefaultPigkingOption",
		label = "Default Pigking",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "TorchPigkingOption",
		label = "Torch Pigking",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "FisherPigOption",
		label = "Fisher Pig",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "SwampPigOption",
		label = "Swamp Pig",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "DeciduousPondOption",
		label = "Deciduous Pond",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 3,
	},
	{
		name = "ChessSpot1Option",
		label = "Chess Spot 1",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "ChessSpot2Option",
		label = "Chess Spot 2",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "ChessSpot3Option",
		label = "Chess Spot 3",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "Maxwell1Option",
		label = "Maxwell 1",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "Maxwell2Option",
		label = "Maxwell 2",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "Maxwell3Option",
		label = "Maxwell 3",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "Maxwell4Option",
		label = "Maxwell 4",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "Maxwell5Option",
		label = "Maxwell 5",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "Maxwell6Option",
		label = "Maxwell 6",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "Maxwell7Option",
		label = "Maxwell 7",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
-- Cave Biomes Set Pieces
	{
		name = "",
		label = "Cave Set Pieces",
			hover = "",
		options =	{
						{description = "", data = 0},
					},
		default = 0,
	},
	{
		name = "CaveBaseOption",
		label = "Cave Base",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 12,
	},
	{
		name = "MushBaseOption",
		label = "Mush Base",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 12,
	},
	{
		name = "SinkBaseOption",
		label = "Sink Base",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 12,
	},
	{
		name = "RuinsCampOption",
		label = "Ruins Camp",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 5,
	},
	{
		name = "RabbitTownOption",
		label = "Rabbit Town",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 8,
	},
	{
		name = "MilitaryEntranceOption",
		label = "Military Entrance",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 1,
	},
	{
		name = "AltarRoomOption",
		label = "Altar Room",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "SpiralOption",
		label = "Spiral",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "BrokenAltarOption",
		label = "Broken Altar",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "Chessy1Option",
		label = "Chessy 1",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "Chessy2Option",
		label = "Chessy 2",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "Chessy3Option",
		label = "Chessy 3",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "Chessy4Option",
		label = "Chessy 4",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "Chessy5Option",
		label = "Chessy 5",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
	{
		name = "Chessy6Option",
		label = "Chessy 6",
			hover = "How many of said Set Pieces can appear on all valid biomes",
		options =	{
						{description = "Disabled", data = 0},
						{description = "1", data = 1},
						{description = "2", data = 2},
						{description = "3", data = 3},
						{description = "4", data = 4},
						{description = "5", data = 5},
						{description = "6", data = 6},
						{description = "7", data = 7},
						{description = "8", data = 8},
						{description = "9", data = 9},
						{description = "10", data = 10},
						{description = "11", data = 11},
						{description = "12", data = 12},
						{description = "13", data = 13},
						{description = "14", data = 14},
						{description = "15", data = 15},
						{description = "16", data = 16},
						{description = "17", data = 17},
						{description = "18", data = 18},
						{description = "19", data = 19},
						{description = "20", data = 20},
						{description = "25", data = 25},
						{description = "30", data = 30},
						{description = "35", data = 35},
						{description = "40", data = 40},
						{description = "45", data = 45},
						{description = "50", data = 50},
					},
		default = 2,
	},
}

--Adds a priority to the mod. Loads it before or after other mods. This can help to fix various incompatibilities between other mods.
priority = 8888.88487878488