require "prefabutil"

local assets=
{
	Asset("ATLAS", "images/inventoryimages/wooddoor.xml"),
    Asset("IMAGE", "images/inventoryimages/wooddoor.tex"),
	Asset("ATLAS", "images/inventoryimages/haydoor.xml"),
    Asset("IMAGE", "images/inventoryimages/haydoor.tex"),
	Asset("ATLAS", "images/inventoryimages/stonedoor.xml"),
    Asset("IMAGE", "images/inventoryimages/stonedoor.tex"),
	Asset("ATLAS", "images/inventoryimages/ruindoor.xml"),
    Asset("IMAGE", "images/inventoryimages/ruindoor.tex"),
	Asset("ATLAS", "images/inventoryimages/limestonedoor.xml"),
    Asset("IMAGE", "images/inventoryimages/limestonedoor.tex"),
	Asset("ATLAS", "images/inventoryimages/limestonewall.xml"),
    Asset("IMAGE", "images/inventoryimages/limestonewall.tex"),
	Asset("ATLAS", "images/inventoryimages/moonrockdoor.xml"),
    Asset("IMAGE", "images/inventoryimages/moonrockdoor.tex"),
	
	Asset("ANIM", "anim/dyc_wall_limestone.zip"),
}

local prefabs =
{
	-- "collapse_small",
}


local function OnIsPathFindingDirty(inst)
    if inst._ispathfinding:value() then
        if inst._pfpos == nil then
            inst._pfpos = inst:GetPosition()
            TheWorld.Pathfinder:AddWall(inst._pfpos:Get())
        end
    elseif inst._pfpos ~= nil then
        TheWorld.Pathfinder:RemoveWall(inst._pfpos:Get())
        inst._pfpos = nil
    end
end

local function InitializePathFinding(inst)
    inst:ListenForEvent("onispathfindingdirty", OnIsPathFindingDirty)
    OnIsPathFindingDirty(inst)
end



local function makeobstacle(inst)
    inst.Physics:SetActive(true)
    inst._ispathfinding:set(true)
end

local function clearobstacle(inst)
    inst.Physics:SetActive(false)
    inst._ispathfinding:set(false)
end

local function getwallanim_dyc (inst)
	local wallpercent=inst.wallpercent
	if wallpercent>=1 then
		return "fullA"
	elseif wallpercent>=0.75 then
		return "threequarter"
	elseif wallpercent>=0.5 then
		return "half"
	elseif wallpercent>=0.25 then
		return "onequarter"
	elseif wallpercent>=0 then
		return "broken"
	end
	return "broken"
end

local function updatewallphysics (inst)
	if inst.doorstate and inst.components.workable.workleft>0 then
		makeobstacle(inst)
	else 
		clearobstacle(inst)
	end
end

local function quantizeposition(pt)
	local retval = Vector3(math.floor(pt.x)+.5, 0, math.floor(pt.z)+.5)
	return retval
end 

local function ondeploywall(inst, pt, deployer)
	--inst.SoundEmitter:PlaySound("dontstarve/creatures/spider/spider_egg_sack")
	local wall = SpawnPrefab(inst.deployprefab) 
	
	if wall then 
		pt = quantizeposition(pt)
		wall.Physics:SetCollides(false)
		wall.Physics:Teleport(pt.x, 0, pt.z) 
		wall.Physics:SetCollides(true)
		inst.components.stackable:Get():Remove()

		TheWorld.Pathfinder:AddWall(pt.x, 0, pt.z)
		
	end 		
end

local function onhammered(inst, worker)
	if not inst.islastworkvalid then
		return
	end
	
	if inst.loot then
		local num_loots = 1
		for k = 1, num_loots do
			inst.components.lootdropper:SpawnLootPrefab(inst.loot)
		end
	end
		
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
		
	if inst.destroysound then
		inst.SoundEmitter:PlaySound(inst.destroysound)
		-- ???
	end
	
	-- set material ?
	
	inst:Remove()
end





local function onhealthchange(inst, old_percent, new_percent)
	inst.components.health.currenthealth = inst.components.health.maxhealth
	new_percent=1
	if old_percent <= 0 and new_percent > 0 then makeobstacle(inst) end
	if old_percent > 0 and new_percent <= 0 then clearobstacle(inst) end

	local anim_to_play = getwallanim_dyc(inst)
	if inst.wallpercent==0 then
		inst.AnimState:PlayAnimation(anim_to_play)		
	else
		inst.AnimState:PlayAnimation(anim_to_play.."_hit")		
		inst.AnimState:PushAnimation(anim_to_play, false)
	end
	
end

local function dooritemfn(initfn)

		local inst = CreateEntity()
		inst:AddTag("wallbuilder")
		
		inst.entity:AddTransform()
		inst.entity:AddAnimState()
		inst.entity:AddNetwork()
		MakeInventoryPhysics(inst)
		
		initfn(inst)
		
		inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end

		inst:AddComponent("stackable")
		inst.components.stackable.maxsize = TUNING.STACK_SIZE_MEDITEM

		inst:AddComponent("inspectable")
		inst:AddComponent("inventoryitem")
		
		inst:AddComponent("deployable")
		inst.components.deployable.ondeploy = ondeploywall
		inst.components.deployable:SetDeployMode(DEPLOYMODE.WALL)
		-- inst.components.deployable.test = test_wall
		-- inst.components.deployable.min_spacing = 0
		-- inst.components.deployable:SetQuantizeFunction(quantizeposition)
		-- inst.components.deployable.deploydistance = 1.5
		
		MakeHauntableLaunch(inst)
		
		return inst
end

local function onhit(inst)
	if inst.destroysound then
		inst.SoundEmitter:PlaySound(inst.destroysound)		
	end
	if inst.wallpercent>inst.components.workable.workleft/inst.iniworkleft then 
		inst.wallpercent=inst.components.workable.workleft/inst.iniworkleft
	end
	if inst.wallpercent<0 then 
		inst.wallpercent=0
	end
	local anim_to_play = getwallanim_dyc(inst)
	if inst.wallpercent==0 then
		inst.AnimState:PlayAnimation(anim_to_play)		
	else
		inst.AnimState:PlayAnimation(anim_to_play.."_hit")		
		inst.AnimState:PushAnimation(anim_to_play, false)
	end
	

end

local function onwork(inst,worker,workleft)
	
	local hashammer=false
	if worker.components.inventory then
		for k,v in pairs(worker.components.inventory.equipslots) do
			if v.components.tool and v.components.tool:CanDoAction(ACTIONS.HAMMER) then
				hashammer=true
				break
			end
		end
	end
	if not hashammer then
		inst.islastworkvalid=false
		inst.components.workable.destroyed=false
		inst.components.workable.workleft=inst.workleft
	else
		inst.islastworkvalid=true
		onhit(inst)
		inst.workleft=inst.workleft-0.25*inst.iniworkleft
		inst.components.workable.workleft=inst.workleft
	end
end

local function onattacked(inst,attacker,damage)
	onhit(inst)
	if TUNING.DYC_SUPERWALL_REBOUNDDAMAGE>0 and attacker.components.combat then
		-- print(attacker.name.."attacked"..inst.name)
		attacker.components.combat:GetAttacked(inst,TUNING.DYC_SUPERWALL_REBOUNDDAMAGE,nil)
	end

end


local function onload(inst)
	if inst.components.workable.workleft<0.25*inst.iniworkleft then
		inst.components.workable.workleft=inst.iniworkleft
	end
	inst.workleft=inst.components.workable.workleft
	inst.wallpercent=inst.components.workable.workleft/inst.iniworkleft
	inst.AnimState:PlayAnimation(getwallanim_dyc(inst))
	updatewallphysics(inst)
end

local function onremoveentity(inst)
	clearobstacle(inst)
	OnIsPathFindingDirty(inst)
	if inst.doortask then
		inst.doortask:Cancel()
	end
	if inst.doortask2 then
		inst.doortask2:Cancel()
	end
end


local function update_door (inst)
	
	local opendoor = false
	local instpos = Vector3(inst.Transform:GetWorldPosition())
	for k,v in pairs(AllPlayers) do
		local playerpos = Vector3(v.Transform:GetWorldPosition())
		local distance = playerpos:Dist(instpos)
		-- print(distance)
		if distance<TUNING.DYC_SUPERWALL_DOORDETECTRANGE then
			opendoor=true
			break
		end
	end
	
	if opendoor then
		inst.doorchanging=-1
	else
		inst.doorchanging=1
	end
	
end

local function update_door2 (inst)
	if inst.doorchanging<0 and inst.wallpercent>0 then
		inst.wallpercent = inst.wallpercent-0.25
		if inst.wallpercent<=0 then
			inst.wallpercent=0
			inst.doorstate=false
			updatewallphysics(inst)
		end
		inst.AnimState:PlayAnimation(getwallanim_dyc(inst))
	elseif inst.doorchanging>0 and inst.wallpercent<inst.components.workable.workleft/inst.iniworkleft then
		inst.wallpercent = inst.wallpercent+0.25
		if inst.wallpercent>=inst.components.workable.workleft/inst.iniworkleft then
			inst.wallpercent=inst.components.workable.workleft/inst.iniworkleft
			inst.doorstate=true
			updatewallphysics(inst)
		end
		inst.AnimState:PlayAnimation(getwallanim_dyc(inst))
	end
end

local function doorfn (initfn) 
		local inst = CreateEntity()
		local trans = inst.entity:AddTransform()
		
		
		inst.doorstate=true
		inst.doorchanging=1
		inst.wallpercent=1
		inst.iniworkleft=4
		inst.workleft=inst.iniworkleft
		inst.islastworkvalid=false
		
		
		inst.entity:AddAnimState()
		inst.entity:AddSoundEmitter()
		inst.entity:AddNetwork()
		
		trans:SetEightFaced()
		
		--trans:SetScale(1.3,1.3,1.3)
		inst:AddTag("wall")
		inst:AddTag("floodblocker")
		MakeObstaclePhysics(inst, .5)    
		inst.Physics:SetDontRemoveOnSleep(true)
		
		initfn(inst)
		
		MakeSnowCoveredPristine(inst)
		
		inst._pfpos = nil
        inst._ispathfinding = net_bool(inst.GUID, "_ispathfinding", "onispathfindingdirty")
        makeobstacle(inst)
        
        inst:DoTaskInTime(0, InitializePathFinding)

        
	    inst.OnRemoveEntity = onremoveentity
		
		

        inst.entity:SetPristine()

        if not TheWorld.ismastersim then
            return inst
        end
		
		inst.OnLoad = onload
		inst.doortask = inst:DoPeriodicTask(0.25, function() update_door(inst) end)
		inst.doortask2 = inst:DoPeriodicTask(2*FRAMES, function() update_door2(inst) end)
		
		inst:AddComponent("inspectable")
		inst:AddComponent("lootdropper")
		
		inst:AddComponent("combat")
		inst.components.combat.onhitfn = onattacked
		
		inst:AddComponent("health")
		inst.components.health:SetMaxHealth(1000)
		inst.components.health.currenthealth = 1000
		inst.components.health.ondelta = onhealthchange
		inst.components.health.nofadeout = true
		inst.components.health.canheal = false
		inst:AddTag("noauradamage")

		inst:AddComponent("workable")
		inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
		inst.components.workable:SetWorkLeft(inst.iniworkleft)
		inst.components.workable:SetOnFinishCallback(onhammered)
		inst.components.workable:SetOnWorkCallback(onwork) 	
		inst.components.workable.savestate=true

		MakeHauntableWork(inst)
		MakeSnowCovered(inst)
		
		return inst
end

local function wooddooritem (initfn2) 
	local inst = dooritemfn(function (inst,init) 
		inst.deployprefab="dyc_door_wood"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_wood")
		inst.AnimState:PlayAnimation("idle")
		if initfn2 then
			initfn2(inst)
		end
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages/wooddoor.xml"
	inst.components.inventoryitem.imagename = "wooddoor"
	-- inst.components.deployable.placer = "dyc_door_wood_placer"
	
	return inst
end

local function wooddooritem2 ()
	local inst = wooddooritem()
	return inst
end

local function wooddoor () 
	local inst = doorfn(function (inst) 
		inst.loot="log"
		inst.buildsound="dontstarve/common/place_structure_wood"
		inst.destroysound="dontstarve/common/destroy_wood"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_wood")
		inst.AnimState:PlayAnimation("fullA", false)
		inst.SoundEmitter:PlaySound(inst.buildsound)
		inst:AddTag("wood")
		
	end)

	return inst
end

local function haydooritem (initfn2) 
	local inst = dooritemfn(function (inst) 
		inst.deployprefab="dyc_door_hay"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_hay")
		inst.AnimState:PlayAnimation("idle")
		if initfn2 then
			initfn2(inst)
		end
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages/haydoor.xml"
	inst.components.inventoryitem.imagename = "haydoor"
	-- inst.components.deployable.placer = "dyc_door_hay_placer"
	
	return inst
end

local function haydooritem2 ()
	local inst = haydooritem()
	return inst
end

local function haydoor () 
	local inst = doorfn(function (inst) 
		inst.loot="cutgrass"
		inst.buildsound="dontstarve/common/place_structure_straw"
		inst.destroysound="dontstarve/common/destroy_straw"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_hay")
		inst.AnimState:PlayAnimation("fullA", false)
		inst.SoundEmitter:PlaySound(inst.buildsound)
		inst:AddTag("grass")
		
	end)

	return inst
end

local function stonedooritem (initfn2) 
	local inst = dooritemfn(function (inst) 
		inst.deployprefab="dyc_door_stone"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_stone")
		inst.AnimState:PlayAnimation("idle")
		if initfn2 then
			initfn2(inst)
		end
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages/stonedoor.xml"
	inst.components.inventoryitem.imagename = "stonedoor"
	-- inst.components.deployable.placer = "dyc_door_stone_placer"
	
	return inst
end

local function stonedooritem2 ()
	local inst = stonedooritem()
	return inst
end

local function stonedoor () 
	local inst = doorfn(function (inst) 
		inst.loot="rocks"
		inst.buildsound="dontstarve/common/place_structure_stone"
		inst.destroysound="dontstarve/common/destroy_stone"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_stone")
		inst.AnimState:PlayAnimation("fullA", false)
		inst.SoundEmitter:PlaySound(inst.buildsound)
		inst:AddTag("stone")
		
	end)

	return inst
end

local function ruindooritem (initfn2) 
	local inst = dooritemfn(function (inst) 
		inst.deployprefab="dyc_door_ruin"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_ruins")
		inst.AnimState:PlayAnimation("idle")
		if initfn2 then
			initfn2(inst)
		end
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages/ruindoor.xml"
	inst.components.inventoryitem.imagename = "ruindoor"
	-- inst.components.deployable.placer = "dyc_door_ruin_placer"
	
	return inst
end

local function ruindooritem2 ()
	local inst = ruindooritem()
	return inst
end

local function ruindoor () 
	local inst = doorfn(function (inst) 
		inst.loot="thulecite_pieces"
		inst.buildsound="dontstarve/common/place_structure_stone"
		inst.destroysound="dontstarve/common/destroy_stone"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_ruins")
		inst.AnimState:PlayAnimation("fullA", false)
		inst.SoundEmitter:PlaySound(inst.buildsound)
		inst:AddTag("stone")
		inst:AddTag("ruins")
		
	end)

	return inst
end

local function limestonedooritem (initfn2) 
	local inst = dooritemfn(function (inst) 
		inst.deployprefab="dyc_door_limestone"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("dyc_wall_limestone")
		inst.AnimState:PlayAnimation("idle")
		if initfn2 then
			initfn2(inst)
		end
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages/limestonedoor.xml"
	inst.components.inventoryitem.imagename = "limestonedoor"
	-- inst.components.deployable.placer = "dyc_door_limestone_placer"
	
	return inst
end

local function limestonedooritem2 ()
	local inst = limestonedooritem()
	return inst
end

local function limestonedoor () 
	local inst = doorfn(function (inst) 
		inst.loot="rocks"
		inst.buildsound="dontstarve/common/place_structure_stone"
		inst.destroysound="dontstarve/common/destroy_stone"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("dyc_wall_limestone")
		inst.AnimState:PlayAnimation("fullA", false)
		inst.SoundEmitter:PlaySound(inst.buildsound)
		inst:AddTag("stone")
		
	end)

	return inst
end

local function moonrockdooritem (initfn2) 
	local inst = dooritemfn(function (inst) 
		inst.deployprefab="dyc_door_moonrock"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_moonrock")
		inst.AnimState:PlayAnimation("idle")
		if initfn2 then
			initfn2(inst)
		end
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages/moonrockdoor.xml"
	inst.components.inventoryitem.imagename = "moonrockdoor"
	-- inst.components.deployable.placer = "dyc_door_limestone_placer"
	
	return inst
end

local function moonrockdooritem2 ()
	local inst = moonrockdooritem()
	return inst
end

local function moonrockdoor () 
	local inst = doorfn(function (inst) 
		inst.loot="moonrocknugget"
		inst.buildsound="dontstarve/common/place_structure_stone"
		inst.destroysound="dontstarve/common/destroy_stone"
		inst.AnimState:SetBank("wall")
		inst.AnimState:SetBuild("wall_moonrock")
		inst.AnimState:PlayAnimation("fullA", false)
		inst.SoundEmitter:PlaySound(inst.buildsound)
		inst:AddTag("stone")
		inst:AddTag("moonrock")
		
	end)

	return inst
end
-- ===============================walls=====================================================
local function woodwallitem () 
	local inst = wooddooritem(function (inst) 
		inst.deployprefab="dyc_wall_wood"
		
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_wood_item"
	
	return inst
end

local function woodwall () 
	local inst = wooddoor()
	if not TheWorld.ismastersim then
        return inst
    end
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function haywallitem () 
	local inst = haydooritem(function (inst) 
		inst.deployprefab="dyc_wall_hay"
		
	end)
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_hay_item"
	
	return inst
end

local function haywall () 
	local inst = haydoor()
	if not TheWorld.ismastersim then
        return inst
    end
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function stonewallitem () 
	local inst = stonedooritem(function (inst) 
		inst.deployprefab="dyc_wall_stone"
		
	end)
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_stone_item"
	
	return inst
end

local function stonewall () 
	local inst = stonedoor()
	if not TheWorld.ismastersim then
        return inst
    end
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function ruinwallitem () 
	local inst = ruindooritem(function (inst) 
		inst.deployprefab="dyc_wall_ruin"
		
	end)
	
	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_ruins_item"
	
	return inst
end

local function ruinwall () 
	local inst = ruindoor()
	if not TheWorld.ismastersim then
        return inst
    end
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function limestonewallitem () 
	local inst = limestonedooritem(function (inst) 
		inst.deployprefab="dyc_wall_limestone"
		
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages/limestonewall.xml"
	inst.components.inventoryitem.imagename = "limestonewall"
	
	return inst
end

local function limestonewall () 
	local inst = limestonedoor()
	if not TheWorld.ismastersim then
        return inst
    end
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end

local function moonrockwallitem () 
	local inst = moonrockdooritem(function (inst) 
		inst.deployprefab="dyc_wall_moonrock"
		
	end)

	if not TheWorld.ismastersim then
        return inst
    end
	inst.components.inventoryitem.atlasname = "images/inventoryimages.xml"
	inst.components.inventoryitem.imagename = "wall_moonrock_item"
	
	return inst
end

local function moonrockwall () 
	local inst = moonrockdoor()
	if not TheWorld.ismastersim then
        return inst
    end
	inst.doortask:Cancel()
	inst.doortask2:Cancel()
	return inst
end


return 
Prefab( "common/dyc_wall_moonrock", moonrockwall, assets, prefabs),
Prefab( "common/dyc_wall_moonrock_item", moonrockwallitem, assets, prefabs),
MakePlacer("common/dyc_wall_moonrock_item_placer", "wall", "wall_moonrock", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_wall_limestone", limestonewall, assets, prefabs),
Prefab( "common/dyc_wall_limestone_item", limestonewallitem, assets, prefabs),
MakePlacer("common/dyc_wall_limestone_item_placer", "wall", "dyc_wall_limestone", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_wall_ruin", ruinwall, assets, prefabs),
Prefab( "common/dyc_wall_ruin_item", ruinwallitem, assets, prefabs),
MakePlacer("common/dyc_wall_ruin_item_placer", "wall", "wall_ruins", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_wall_stone", stonewall, assets, prefabs),
Prefab( "common/dyc_wall_stone_item", stonewallitem, assets, prefabs),
MakePlacer("common/dyc_wall_stone_item_placer", "wall", "wall_stone", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_wall_hay", haywall, assets, prefabs),
Prefab( "common/dyc_wall_hay_item", haywallitem, assets, prefabs),
MakePlacer("common/dyc_wall_hay_item_placer", "wall", "wall_hay", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_wall_wood", woodwall, assets, prefabs),
Prefab( "common/dyc_wall_wood_item", woodwallitem, assets, prefabs),
MakePlacer("common/dyc_wall_wood_item_placer", "wall", "wall_wood", "fullA", false, false, true, nil, nil, "eight") ,

Prefab( "common/dyc_door_moonrock", moonrockdoor, assets, prefabs),
Prefab( "common/dyc_door_moonrock_item", moonrockdooritem2, assets, {"dyc_door_moonrock","dyc_door_moonrock_item_placer"}),
MakePlacer("common/dyc_door_moonrock_item_placer", "wall", "wall_moonrock", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_door_limestone", limestonedoor, assets, prefabs),
Prefab( "common/dyc_door_limestone_item", limestonedooritem2, assets, {"dyc_door_limestone","dyc_door_limestone_item_placer"}),
MakePlacer("common/dyc_door_limestone_item_placer", "wall", "dyc_wall_limestone", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_door_ruin", ruindoor, assets, prefabs),
Prefab( "common/dyc_door_ruin_item", ruindooritem2, assets, {"dyc_door_ruin","dyc_door_ruin_item_placer"}),
MakePlacer("common/dyc_door_ruin_item_placer", "wall", "wall_ruins", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_door_stone", stonedoor, assets, prefabs),
Prefab( "common/dyc_door_stone_item", stonedooritem2, assets, {"dyc_door_stone","dyc_door_stone_item_placer"}),
MakePlacer("common/dyc_door_stone_item_placer", "wall", "wall_stone", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_door_hay", haydoor, assets, prefabs),
Prefab( "common/dyc_door_hay_item", haydooritem2, assets, {"dyc_door_hay","dyc_door_hay_item_placer"}),
MakePlacer("common/dyc_door_hay_item_placer", "wall", "wall_hay", "fullA", false, false, true, nil, nil, "eight") ,
Prefab( "common/dyc_door_wood", wooddoor, assets, prefabs),
Prefab( "common/dyc_door_wood_item", wooddooritem2, assets, {"dyc_door_wood","dyc_door_wood_item_placer"}),
MakePlacer("common/dyc_door_wood_item_placer", "wall", "wall_wood", "fullA", false, false, true, nil, nil, "eight") 

