
local Assets =
{
	Asset("ANIM", "anim/hat_desert.zip"),
	Asset("IMAGE", "images/inventoryimages/hat_desert.tex"),
	Asset("ATLAS", "images/inventoryimages/hat_desert.xml"),	 
}


local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_hat", "hat_desert", "swap_hat")
	owner.AnimState:Show("HAT")
	owner.AnimState:Show("HAT_HAIR")
	owner.AnimState:Hide("HAIR_NOHAT")
	owner.AnimState:Hide("HAIR")
	owner.SoundEmitter:PlaySound("dontstarve/wilson/equip_item_gold")  
		
	if owner:HasTag("player") then
		owner.AnimState:Hide("HEAD")
		owner.AnimState:Show("HEAD_HAT")
	end
		
	inst.components.fueled:StartConsuming()
end

local function onunequip(inst, owner)
	owner.AnimState:ClearOverrideSymbol("swap_hat")
	owner.AnimState:Hide("HAT")
	owner.AnimState:Hide("HAT_HAIR")
	owner.AnimState:Show("HAIR_NOHAT")
	owner.AnimState:Show("HAIR")

	if owner:HasTag("player") then
		owner.AnimState:Show("HEAD")
		owner.AnimState:Hide("HEAD_HAT")
	end

	inst.components.fueled:StopConsuming()
end


local function fn(Sim)
	local inst = CreateEntity()

	inst.entity:AddTransform()
	inst.entity:AddAnimState()
	inst.entity:AddNetwork()
	
	MakeInventoryPhysics(inst)

	inst.AnimState:SetBank("hat_desert")
	inst.AnimState:SetBuild("hat_desert")
	inst.AnimState:PlayAnimation("anim")

	inst:AddTag("hat")
	inst:AddTag("hat_desert")

	inst.entity:SetPristine()
	if not TheWorld.ismastersim then
		return inst
	end

	inst:AddComponent("inspectable")

	inst:AddComponent("inventoryitem")
	inst:AddComponent("tradable")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/hat_desert.xml"
	
	inst:AddComponent("equippable")
	inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
	inst.components.equippable.dapperness = TUNING.DAPPERNESS_LARGE
	inst.components.equippable.walkspeedmult = TUNING.CANE_SPEED_MULT
	
	inst.components.equippable:SetOnEquip( onequip )
	inst.components.equippable:SetOnUnequip( onunequip )
	
	inst:AddComponent("waterproofer")
	
	inst:AddComponent("fueled")
    inst.components.fueled.fueltype = FUELTYPE.USAGE
    inst.components.fueled:InitializeFuelLevel(TUNING.RAINCOAT_PERISHTIME)
    inst.components.fueled:SetDepletedFn(inst.Remove)
	
	MakeHauntableLaunch(inst)

	return inst
end

return Prefab( "common/inventory/hat_desert", fn, Assets)

