---------------------------------------------------------------------------------------------------------------------------
local _G = GLOBAL
local TimeEvent = _G.TimeEvent
local FRAMES = _G.FRAMES
local EQUIPSLOTS = _G.EQUIPSLOTS
local EventHandler = _G.EventHandler
local GetWorld = _G.GetWorld
local SpawnPrefab = _G.SpawnPrefab
local State = _G.State
local DEGREES = _G.DEGREES
local Vector3 = _G.Vector3
local STRINGS = _G.STRINGS
local ACTIONS = _G.ACTIONS
local FOODTYPE = _G.FOODTYPE
local fast_do = "On"
local fast_eat = "On"
AddStategraphPostInit("wilson_client", function(sg)
	if fast_do then
		local state_dolongaction = sg.states["dolongaction"]
		state_dolongaction.onenter = function(inst)
            inst.components.locomotor:Stop()
            inst:PerformPreviewBufferedAction()
			inst.sg:RemoveStateTag("busy")
            inst.sg:SetTimeout(2 * FRAMES)
        end
		state_dolongaction.timeline =
        {
        }
		state_dolongaction.ontimeout = function(inst)
			inst:ClearBufferedAction()
            inst.sg:GoToState("idle", true)
        end
		state_dolongaction.onexit = function(inst)
		end
		state_dolongaction.onupdate = function(inst)
		end
		state_dolongaction.events =
		{
		}
		local state_doshortaction = sg.states["doshortaction"]
		state_doshortaction.onenter = function(inst)
            inst.components.locomotor:Stop()
            inst:PerformPreviewBufferedAction()
			inst.sg:RemoveStateTag("busy")
            inst.sg:SetTimeout(2 * FRAMES)
        end
		state_doshortaction.timeline =
        {  
        }
		state_doshortaction.ontimeout = function(inst)
			inst:ClearBufferedAction()
            inst.sg:GoToState("idle", true)
        end
		state_doshortaction.onexit = function(inst)
		end
		state_doshortaction.onupdate = function(inst)
		end
		state_doshortaction.events =
		{
		}
	end
	if fast_eat then
		local state_eat = sg.states["eat"]
		state_eat.onenter = function(inst)
            inst.components.locomotor:Stop()
            inst.AnimState:PlayAnimation("quick_eat_pre")
            inst.AnimState:PushAnimation("quick_eat_lag", false)
            inst:PerformPreviewBufferedAction()
            inst.sg:SetTimeout(10 * FRAMES)
        end
		state_eat.onupdate = function(inst)
        end
		state_eat.ontimeout = function(inst)
            inst.sg:GoToState("idle")
        end
		state_eat.onexit = function(inst)
		end
		state_eat.timeline =
		{
		}
		state_eat.events =
		{
		}
	end
end)
---------------------------------------------------------------------------------------------------------------------------




