local assets=
{
    Asset("ANIM", "anim/idleshadowstuff.zip"),
    Asset("ANIM", "anim/swap_shadowstaff.zip"),
 
		Asset("ATLAS", "images/inventoryimages/shadowstaff.xml"),
	Asset("IMAGE", "images/inventoryimages/shadowstaff.tex"),
}


local function onfinished(inst)

    inst.SoundEmitter:PlaySound("dontstarve/common/gem_shatter")
    inst:Remove()
end

local function swingspell(inst, attacker, target)
	  --  attacker.SoundEmitter:PlaySound("dontstarve/wilson/attack_icestaff")
end

local function onattack(inst, attacker, target)

 if target.components.combat ~= nil then
  attacker.components.sanity:DoDelta(-1)
 attacker.components.health:DoDelta(1)
 end
end

local function OnEquip(inst, owner)


        owner.AnimState:OverrideSymbol("swap_object", "swap_shadowstaff", "swap_shadowstaff")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
end
	
 
local function OnUnequip(inst, owner)

        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
end




local function fn(Sim)
    local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
    inst.entity:AddSoundEmitter()
	inst.entity:AddNetwork()
    MakeInventoryPhysics(inst)
    
    inst.AnimState:SetBank("idleshadowstuff")
    inst.AnimState:SetBuild("idleshadowstuff")
    inst.AnimState:PlayAnimation("staff")

    inst:AddTag("nopunch")
    
      inst.entity:SetPristine()


    if not TheWorld.ismastersim then
        return inst
    end
	
    inst:AddComponent("inspectable")
    



	inst:AddTag("waterproofer")
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.01)



    
    inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
		    inst.components.equippable.dapperness = - TUNING.DAPPERNESS_TINY
	
	inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "shadowstaff"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shadowstaff.xml"
	
		inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(40)
	inst.components.weapon:SetRange(7,20)
	inst.components.weapon:SetOnAttack(onattack)
    inst.components.weapon:SetProjectile("shadowstaffprojectile")
		inst.components.weapon:SetOnProjectileLaunch(swingspell)


			inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
	   inst.components.finiteuses:SetOnFinished(onfinished) 


	     MakeHauntableLaunch(inst)

    
    return inst
end

return Prefab( "common/inventory/shadowstaff", fn, assets) 
