local assets=
{
    Asset("ANIM", "anim/idleshadowstuff.zip"),
    Asset("ANIM", "anim/swap_shadowspear.zip"),
 
		Asset("ATLAS", "images/inventoryimages/shadowspear.xml"),
	Asset("IMAGE", "images/inventoryimages/shadowspear.tex"),
}

prefabs = {
}

local function onfinished(inst)
    inst:Remove()
end

    local function OnEquip(inst, owner)

        owner.AnimState:OverrideSymbol("swap_object", "swap_shadowspear", "swap_shadowspear")
        owner.AnimState:Show("ARM_carry")
        owner.AnimState:Hide("ARM_normal")
    end
	
 
    local function OnUnequip(inst, owner)
        owner.AnimState:Hide("ARM_carry")
        owner.AnimState:Show("ARM_normal")
    end


local function fn(sim)
	local inst = CreateEntity()
	local trans = inst.entity:AddTransform()
	local anim = inst.entity:AddAnimState()
	inst.entity:AddSoundEmitter()
    MakeInventoryPhysics(inst)
	inst.entity:AddNetwork()
     
    anim:SetBank("idleshadowstuff")
    anim:SetBuild("idleshadowstuff")
    anim:PlayAnimation("spear")

    inst:AddTag("sharp")
        inst:AddTag("shadow")

      if not TheWorld.ismastersim then
        return inst
    end



	inst.entity:SetPristine()

    				        inst:AddTag("SCARYTOPREY")
		
		    inst:AddComponent("inspectable")
    inst:AddComponent("weapon")
    inst.components.weapon:SetDamage(43)



		inst:AddTag("waterproofer")
    inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(0.01)
     
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.imagename = "shadowspear"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shadowspear.xml"
     
	 
    inst:AddComponent("equippable")
    inst.components.equippable:SetOnEquip(OnEquip)
    inst.components.equippable:SetOnUnequip(OnUnequip)
		    inst.components.equippable.dapperness = - TUNING.DAPPERNESS_TINY
	
    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(150)
    inst.components.finiteuses:SetUses(150)
    inst.components.finiteuses:SetOnFinished(onfinished)

            MakeHauntableLaunch(inst)
 
    return inst
end

return  Prefab("common/inventory/shadowspear", fn, assets, prefabs)