local assets =
{
    Asset("ANIM", "anim/swap_shadowhat.zip"),
	Asset("ATLAS", "images/inventoryimages/shadowhelm.xml"),
	Asset("IMAGE", "images/inventoryimages/shadowhelm.tex"),
}



local function OnBlocked(owner, data)
    owner.SoundEmitter:PlaySound("dontstarve/wilson/hit_armour")
 if owner.components.sanity ~= nil then
 owner.components.sanity:DoDelta(-0.5)
end
end

local function onequip(inst, owner)
        owner.AnimState:Show("HAT")
        owner.AnimState:Show("HAIR_HAT")
        owner.AnimState:Hide("HAIR_NOHAT")
        owner.AnimState:Hide("HAIR")
	
 --    -   if owner:HasTag("player") then
   --         owner.AnimState:Hide("HEAD")
    --        owner.AnimState:Show("HEAD_HAT")
   --     end	
		
    owner.AnimState:OverrideSymbol("swap_hat", "swap_shadowhat", "swap_hat")
    inst:ListenForEvent("blocked", OnBlocked, owner)
	inst:ListenForEvent("attacked", OnBlocked, owner)

end

local function onunequip(inst, owner)
        if owner:HasTag("player") then
            owner.AnimState:Show("HEAD")
            owner.AnimState:Hide("HEAD_HAT")
        end

        owner.AnimState:ClearOverrideSymbol("swap_hat")
        owner.AnimState:Hide("HAT")
        owner.AnimState:Hide("HAIR_HAT")
        owner.AnimState:Show("HAIR_NOHAT")
        owner.AnimState:Show("HAIR")
    owner.AnimState:ClearOverrideSymbol("swap_hat")
    inst:RemoveEventCallback("blocked", OnBlocked, owner)
	inst:RemoveEventCallback("attacked", OnBlocked, owner)
	



end

local function fn()
    local inst = CreateEntity()
    inst.entity:AddTransform()
    inst.entity:AddAnimState()
    inst.entity:AddNetwork()

    MakeInventoryPhysics(inst)

    inst.AnimState:SetBank("swap_shadowhat")
    inst.AnimState:SetBuild("swap_shadowhat")
    inst.AnimState:PlayAnimation("anim")

    inst:AddTag("waterproofer")
    inst.foleysound = "dontstarve/movement/foley/nightarmour"

    inst.entity:SetPristine()

    if not TheWorld.ismastersim then
        return inst
    end

    inst:AddComponent("inspectable")




    inst:AddComponent("inventoryitem")
		inst.components.inventoryitem.imagename = "shadowhelm"
    inst.components.inventoryitem.atlasname = "images/inventoryimages/shadowhelm.xml"

    inst:AddComponent("armor")
    inst.components.armor:InitCondition(1200, 0.90)





    inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.HEAD
		    inst.components.equippable.dapperness = - TUNING.DAPPERNESS_TINY
    		
	
	inst:AddTag("waterproofer")
	inst:AddComponent("waterproofer")
    inst.components.waterproofer:SetEffectiveness(TUNING.WATERPROOFNESS_SMALL)



    inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)

    MakeHauntableLaunch(inst)



    return inst
end

return Prefab("shadowhelm", fn, assets)



