
local MakePlayerCharacter = require "prefabs/player_common"


local assets = {

        Asset( "ANIM", "anim/player_basic.zip" ),
        Asset( "ANIM", "anim/player_idles_shiver.zip" ),
        Asset( "ANIM", "anim/player_actions.zip" ),
        Asset( "ANIM", "anim/player_actions_axe.zip" ),
        Asset( "ANIM", "anim/player_actions_pickaxe.zip" ),
        Asset( "ANIM", "anim/player_actions_shovel.zip" ),
        Asset( "ANIM", "anim/player_actions_blowdart.zip" ),
        Asset( "ANIM", "anim/player_actions_eat.zip" ),
        Asset( "ANIM", "anim/player_actions_item.zip" ),
        Asset( "ANIM", "anim/player_actions_uniqueitem.zip" ),
        Asset( "ANIM", "anim/player_actions_bugnet.zip" ),
        Asset( "ANIM", "anim/player_actions_fishing.zip" ),
        Asset( "ANIM", "anim/player_actions_boomerang.zip" ),
        Asset( "ANIM", "anim/player_bush_hat.zip" ),
        Asset( "ANIM", "anim/player_attacks.zip" ),
        Asset( "ANIM", "anim/player_idles.zip" ),
        Asset( "ANIM", "anim/player_rebirth.zip" ),
        Asset( "ANIM", "anim/player_jump.zip" ),
        Asset( "ANIM", "anim/player_amulet_resurrect.zip" ),
        Asset( "ANIM", "anim/player_teleport.zip" ),
        Asset( "ANIM", "anim/wilson_fx.zip" ),
        Asset( "ANIM", "anim/player_one_man_band.zip" ),
        Asset( "ANIM", "anim/shadow_hands.zip" ),
        Asset( "SOUND", "sound/sfx.fsb" ),
        Asset( "SOUND", "sound/wilson.fsb" ),
        Asset( "ANIM", "anim/beard.zip" ),
		Asset("ANIM", "anim/wes.zip"),
	Asset("ANIM", "anim/player_mime.zip"),

		-- Don't forget to include your character's custom assets!
        Asset( "ANIM", "anim/cac.zip" ),
}

local prefabs ={}

local function onbecamehuman(inst)
	inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
end

local function onload(inst)
    inst:ListenForEvent("ms_respawnedfromghost", onbecamehuman)
    if not inst:HasTag("playerghost") then
        onbecamehuman(inst)
	inst.components.locomotor.walkspeed = TUNING.WILSON_WALK_SPEED
	inst.components.locomotor.runspeed = TUNING.WILSON_RUN_SPEED
    end

end

local function OnNewSpawn(inst) 
end

 

	local common_postinit = function(inst)
	inst.soundsname = "weston"
	inst.MiniMapEntity:SetIcon( "weston.tex" )
	--inst.components.talker.font = TALKINGFONT
	inst:AddTag("flower")
	inst.components.talker.colour = Vector3(128/255, 179/255, 95/255)
end

local master_postinit = function(inst)
	
	-- choose which sounds this character will play


	-- a minimap icon must be specified


	-- todo: Add an example special power here.
	inst.components.combat.damagemultiplier = 1.05
	inst.components.health:SetMaxHealth(135)
	inst.components.hunger:SetMax(175)		 
	inst.components.sanity:SetMax(150)
	inst.wetness = inst.components.moisture:GetMoisture()
	--inst.components.sanity.custom_rate_fn = SanityForWetness	
	inst.components.moisture.maxDryingRate = 0.05
	inst.components.moisture.maxPlayerTempDrying = 4
	inst.components.moisture.maxmoisture = 95
	if inst.components.moisture:GetMoisture() > 70 then inst.components.sanity.dapperness = -TUNING.DAPPERNESS_LARGE * 0.5
	end
	inst.components.temperature.overheattemp = 69
	inst.components.temperature.inherentsummerinsulation = 25
	inst.components.temperature.maxtemp = ( 20 )
	inst.components.eater.ignoresspoilage = true
	inst.components.health.fire_damage_scale = 3
	inst.components.temperature.inherentinsulation = -75
	inst.components.combat:SetDefaultDamage(24)
	local Combat = Class(function(self, inst)
	inst.components.combat.attackrange = 2
	inst.components.combat.hitrange = 2
	inst.components.combat.min_attack_period = 2
	inst.components.combat:SetAttackPeriod(2)
    end)
	
	local forbidden = {
	cactus_meat = true,
	cactus_meat_cooked = true,
	cactus_flower = true,
	guacamole = true,
	flowersalad = true,
}

local _PrefersToEat = inst.components.eater.PrefersToEat
inst.components.eater.PrefersToEat = function(self, food)
	return _PrefersToEat(self, food) and not forbidden[food.prefab]
end
	


			inst:ListenForEvent("attacked", function(inst, data)
  if data.attacker and data.attacker.components.health and data.attacker:HasTag("player") then
   data.attacker.components.health:DoDelta(math.random(-15, -9))
   end

  if data.attacker and data.attacker.components.health and not data.attacker:HasTag("player") and not data.attacker:HasTag("chess") then

   data.attacker.components.health:DoDelta(math.random(-18, -12))
   
   end
   
end)

		inst.OnLoad = onload
    inst.OnNewSpawn = onload

end

return MakePlayerCharacter("cac", prefabs, assets, common_postinit, master_postinit)
