PrefabFiles = {
	"cac",
	"cac_none",
}

Assets = {
    Asset( "IMAGE", "images/saveslot_portraits/cac.tex" ),
    Asset( "ATLAS", "images/saveslot_portraits/cac.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/cac.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/cac.xml" ),

    Asset( "IMAGE", "images/selectscreen_portraits/cac_silho.tex" ),
    Asset( "ATLAS", "images/selectscreen_portraits/cac_silho.xml" ),

    Asset( "IMAGE", "bigportraits/cac.tex" ),
    Asset( "ATLAS", "bigportraits/cac.xml" ),
	
	Asset( "IMAGE", "images/map_icons/weston.tex" ),
	Asset( "ATLAS", "images/map_icons/weston.xml" ),
	
	Asset("SOUNDPACKAGE", "sound/weston.fev"),
    Asset("SOUND", "sound/weston.fsb"),
	
	Asset( "IMAGE", "images/avatars/avatar_cac.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_cac.xml" ),
	
	Asset( "ATLAS", "images/weston.xml" ),
	Asset( "IMAGE", "images/weston.tex" ),
	
	Asset( "IMAGE", "images/avatars/avatar_ghost_cac.tex" ),
    Asset( "ATLAS", "images/avatars/avatar_ghost_cac.xml" ),
	
	Asset( "IMAGE", "images/avatars/self_inspect_cac.tex" ),
    Asset( "ATLAS", "images/avatars/self_inspect_cac.xml" ),

}
 
RemapSoundEvent( "dontstarve/characters/weston/death_voice", "weston/characters/weston/death_voice" )
RemapSoundEvent( "dontstarve/characters/weston/hurt", "weston/characters/weston/hurt" )
RemapSoundEvent( "dontstarve/characters/weston/talk_LP", "weston/characters/weston/talk_LP" )
RemapSoundEvent( "dontstarve/characters/weston/emote", "weston/characters/weston/emote" )

local require = GLOBAL.require
local STRINGS = GLOBAL.STRINGS
local Ingredient = GLOBAL.Ingredient
local RECIPETABS = GLOBAL.RECIPETABS
GLOBAL.STRINGS.CHARACTERS.CAC = require "speech_cac"

-- The character select screen lines
-- note: these are lower-case character name
GLOBAL.STRINGS.CHARACTER_TITLES.cac = "The Wandering Cactus"
GLOBAL.STRINGS.CHARACTER_NAMES.cac = "Weston" 
GLOBAL.STRINGS.CHARACTER_DESCRIPTIONS.cac = "*Is covered in sharp spines\n*Loves hot weather\n*Has a flower that attracts bugs"
GLOBAL.STRINGS.CHARACTER_QUOTES.cac = "\"I've got to look sharp!\""

-- Let the game know cac is a male, for proper pronouns during the end-game sequence.
-- Possible genders here are MALE, FEMALE, or ROBOT
--table.insert(GLOBAL.CHARACTER_GENDERS.MALE, "cac")
--AddModCharacter("cac")
AddModCharacter("cac", "MALE")

AddMinimapAtlas("images/weston.xml")

if GLOBAL.IsDLCEnabled(GLOBAL.REIGN_OF_GIANTS) then
    local HeatOver = GLOBAL.require "widgets/heatover"
 
    local HeatOver_OnHeatChange_base = HeatOver.OnHeatChange or function() end
    function HeatOver:OnHeatChange()
        if self.owner.prefab ~= "cac" then
            HeatOver_OnHeatChange_base(self)
        end
    end
end



AddSimPostInit(pickyeater)

STRINGS.CHARACTERS.GENERIC.DESCRIBE.Weston = 
{
    GENERIC = "It's Weston!",
    ATTACKER = "That Weston looks shifty...",
    MURDERER = "Murderer!",
    REVIVER = "Weston, friend of ghosts.",
    GHOST = "Weston could use a heart.",
}

AddPrefabPostInit(
"hawaiianshirt",
 function(inst)
        if not GLOBAL.TheWorld.ismastersim
        then
            return
        end
        local GetDapperness_old = inst.components.equippable.GetDapperness
        inst.components.equippable.GetDapperness = function(self, owner, ...)
            local original_dapperness = GetDapperness_old(self, owner, ...)
            if owner.prefab=="cac"
            then
                return original_dapperness - inst.components.equippable.dapperness + -GLOBAL.TUNING.DAPPERNESS_MED * 2
            end
            return original_dapperness
        end
    end
)