
local assets =
{
    Asset("ANIM", "anim/house2.zip"),

}

local prefabs = 
{
    
}

local function turnon(inst)
    if not inst.components.fueled:IsEmpty() then
    if not inst.components.machine.ison then
    if inst.components.fueled then
    inst.components.fueled:StartConsuming()        
    inst.Light:Enable(true)
    inst.AnimState:PlayAnimation("house2_on")
    inst.AnimState:PushAnimation("house2_on",true)
    inst.components.machine.ison = true
    inst.SoundEmitter:PlaySound("dontstarve/wilson/lantern_on")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/lantern_LP", "loop")
	        end
	    end
	end
end

local function turnoff(inst)
    if inst.components.fueled then
    inst.components.fueled:StopConsuming()        
    inst.AnimState:PlayAnimation("house2")
    inst.AnimState:PushAnimation("house2",true)
    inst.Light:Enable(false)
    inst.components.machine.ison = false
    inst.SoundEmitter:KillSound("loop")
    inst.SoundEmitter:PlaySound("dontstarve/wilson/lantern_off")
	end
end

local function onhammered(inst, worker)
	inst.components.lootdropper:DropLoot()
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/destroy_wood")
	inst:Remove()
end

local function onhit(inst, worker)
end

local function onfinished(inst)
	SpawnPrefab("collapse_small").Transform:SetPosition(inst.Transform:GetWorldPosition())
	inst.SoundEmitter:PlaySound("dontstarve/common/tent_dis_pre")
    inst:Remove()              
end

local function onsleep(inst, sleeper)
	if GetClock():IsDay() then
	if sleeper.components.talker then
	sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODAYSLEEP"))
	return
	end
end
	local hounded = GetWorld().components.hounded
	local danger = FindEntity(inst, 10, function(target) return target:HasTag("monster") or         target.components.combat and target.components.combat.target == inst end)
	if hounded and (hounded.warning or hounded.timetoattack <= 0) then
	danger = true
end
	if danger then
	if sleeper.components.talker then
	sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODANGERSLEEP"))
end
	return
end
	sleeper.components.health:SetInvincible(true)
	sleeper.components.playercontroller:Enable(false)
	TheFrontEnd:Fade(false,1)
	inst:DoTaskInTime(1.2, function() 
	TheFrontEnd:Fade(true,1) 
	if GetClock():IsDay() then
	if sleeper.components.talker then				
	sleeper.components.talker:Say(GetString(inst.prefab, "ANNOUNCE_NODAYSLEEP"))
	sleeper.components.health:SetInvincible(false)
	sleeper.components.playercontroller:Enable(true)
	return
	end
end
	if sleeper.components.sanity then
	sleeper.components.sanity:DoDelta(TUNING.SANITY_HUGE)
end
	if sleeper.components.hunger then
	sleeper.components.hunger:DoDelta(-TUNING.CALORIES_HUGE, false, true)
end
	if sleeper.components.health then
	sleeper.components.health:DoDelta(TUNING.HEALING_HUGE, false, "tent", true)
end
	local season=GetWorld().components.seasonmanager.current_season
	if season ~= inst.lastseasonchecked and season == SEASONS.SUMMER then
	if sleeper.components.temperature then
    sleeper.components.temperature:SetTemperature(0)
	end		
end
	local season=GetWorld().components.seasonmanager.current_season
	if season ~= inst.lastseasonchecked and season == SEASONS.WINTER then
	if sleeper.components.temperature then
    sleeper.components.temperature:SetTemperature(70)
	end		
end
	local moisture_start = nil
	if sleeper.components.moisture and sleeper.components.moisture:GetMoisture() > 0 then
	moisture_start = sleeper.components.moisture.moisture
end
	inst.components.finiteuses:Use()
	GetClock():MakeNextDay()
	sleeper.components.health:SetInvincible(false)
	sleeper.components.playercontroller:Enable(true)
	sleeper.sg:GoToState("wakeup")	
	end)
end	

local function OnLoad(inst, data)
    if inst.components.machine and inst.components.machine.ison then
    inst.AnimState:PushAnimation("house2_on", true)
    turnon(inst)
    inst.Light:Enable(true)
    else
    inst.AnimState:PlayAnimation("house2")
    turnoff(inst)
    inst.Light:Enable(false)
    end
end	

local function fuelupdate(inst)
    local fuelpercent = inst.components.fueled:GetPercent()
    inst.Light:SetIntensity(Lerp(0.4, 0.6, fuelpercent))
    inst.Light:SetRadius(Lerp(4, 6, fuelpercent))
    inst.Light:SetFalloff(.7)
end

local function getstatus(inst, viewer)
	if inst.on then
	if inst.components.fueled and (inst.components.fueled.currentfuel / inst.components.fueled.maxfuel) <= .25 then
	return "LOWFUEL"
	else
	return "ON"
end
	else
	return "OFF"
	end
end

local function fn(Sim)
    local inst = CreateEntity()
    local trans = inst.entity:AddTransform()
    local anim = inst.entity:AddAnimState()
	
    local light = inst.entity:AddLight()
    inst.Light:Enable(false)
    inst.Light:SetRadius(1.5)
    inst.Light:SetFalloff(1)
    inst.Light:SetIntensity(.5)
    inst.Light:SetColour(180/255, 195/255, 150/255)
    
    inst.entity:AddSoundEmitter()
    
    inst:AddTag("structure")	
    inst:AddTag("shelter")
    inst:AddTag("dryshelter")    

    anim:SetBank("house2")
    anim:SetBuild("house2")
    anim:PushAnimation("house2", true)    
   
    inst:AddComponent("lootdropper")
    inst:AddComponent("workable")
    inst.components.workable:SetWorkAction(ACTIONS.HAMMER)
    inst.components.workable:SetWorkLeft(4)
    inst.components.workable:SetOnFinishCallback(onhammered)
    inst.components.workable:SetOnWorkCallback(onhit)     

    inst:AddComponent("inspectable")
       
    MakeObstaclePhysics(inst, 2)    

    local minimap = inst.entity:AddMiniMapEntity()
    minimap:SetIcon("house.tex")

    inst:AddComponent("finiteuses")
    inst.components.finiteuses:SetMaxUses(LIL_USAGE)
    inst.components.finiteuses:SetUses(LIL_USAGE)
    inst.components.finiteuses:SetOnFinished(onfinished)
	    
    inst:AddComponent("sleepingbag") 
    inst.components.sleepingbag.onsleep = onsleep

    inst:AddComponent("fueled")

    inst:AddComponent("machine")
    inst.components.machine.turnonfn = turnon
    inst.components.machine.turnofffn = turnoff
    inst.components.machine.cooldowntime = 0
    inst.components.machine.caninteractfn = function()
    return not inst.components.fueled:IsEmpty() end

	inst:AddComponent("inspectable")
	inst.components.inspectable.getstatus = getstatus

    inst.components.fueled.fueltype = "CAVE"
    inst.components.fueled:InitializeFuelLevel(TUNING.LANTERN_LIGHTTIME)
    inst.components.fueled:SetDepletedFn(turnoff)
    inst.components.fueled:SetUpdateFn(fuelupdate)
	inst.components.fueled:SetSections(10)
    inst.components.fueled.accepting = true    

    fuelupdate(inst)

    inst.OnLoad = OnLoad

    return inst
end	
	
return Prefab( "common/objects/house2", fn, assets),
		MakePlacer( "common/house2_placer", "house2", "house2", "house2" ) 
